/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.DataTypePickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class DataTypePickerControllerImpl
extends AbstractPickerController<DataType>
implements DataTypePickerController {
    private final JButton btnType;
    private final JComboBox cboType;
    private final boolean allowNull;
    private ArrayList<DataType> fieldTypes;

    public DataTypePickerControllerImpl(JComboBox cboType, JButton btnType, boolean allowNull) {
        this.cboType = cboType;
        this.btnType = btnType;
        this.allowNull = allowNull;
        this.initComponents();
    }

    public DataType get() {
        return (DataType)this.cboType.getSelectedItem();
    }

    public void set(DataType value) {
        ListElement.setSelected((JComboBox)this.cboType, (Object)value);
        if (ListElement.getSelected((JComboBox)this.cboType) == null) {
            this.cboType.addItem(value);
            ListElement.setSelected((JComboBox)this.cboType, (Object)value);
        }
    }

    public void coerceAndSet(Object value) {
        if (value instanceof DataType) {
            this.set((DataType)value);
        }
    }

    public void setEnabled(boolean enabled) {
        this.cboType.setEnabled(enabled);
        this.btnType.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return true;
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
        this.fieldTypes = new ArrayList();
        if (this.allowNull) {
            this.fieldTypes.add(null);
        }
        this.fieldTypes.add(dataManager.get(19));
        this.fieldTypes.add(dataManager.get(4));
        this.fieldTypes.add(dataManager.get(8));
        this.fieldTypes.add(dataManager.get(1));
        this.fieldTypes.add(dataManager.get(9));
        this.fieldTypes.add(dataManager.get(11));
        DefaultComboBoxModel<DataType> modelTypes = new DefaultComboBoxModel<DataType>();
        for (DataType element : this.fieldTypes) {
            modelTypes.addElement(element);
        }
        this.cboType.setModel(modelTypes);
        swingManager.setDefaultPopupMenu(this.cboType);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnType, (String)"_Data_type_picker", (String)"picker-datatype", e -> this.doDataTypeSelection(), null);
    }

    private void doDataTypeSelection() {
        final DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ArrayList<ListElement> types = new ArrayList<ListElement>();
        for (Object dataType : dataManager) {
            types.add(new ListElement(dataType.getName(), (Object)dataType.getType()));
        }
        types.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        DefaultListModel<ListElement> modelTypes = new DefaultListModel<ListElement>();
        for (ListElement element : types) {
            modelTypes.addElement(element);
        }
        JList<Object> list = new JList<Object>();
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(null);
                try {
                    DataType dataType = dataManager.get(((Integer)value).intValue());
                    IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
                    if (theme.exists(dataType.getIconName())) {
                        label.setIcon(theme.get(dataType.getIconName()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return label;
            }
        });
        list.setModel(modelTypes);
        JScrollPane scrollpanel = new JScrollPane(list);
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winManager.createDialog((JComponent)scrollpanel, i18n.getTranslation("_Data_type_selection"), i18n.getTranslation("_Select_the_data_type"), 3);
        dialog.addActionListener(e -> {
            Integer type;
            if (dialog.getAction() == 1 && (type = (Integer)ListElement.getSelected((JList)list)) != null) {
                ListElement.setSelected((JComboBox)this.cboType, (Object)type);
                if (ListElement.getSelected((JComboBox)this.cboType) == null) {
                    DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
                    DataType dataType = dataTypeManager.get(type.intValue());
                    this.cboType.addItem(dataType);
                    ListElement.setSelected((JComboBox)this.cboType, (Object)dataType);
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }
}

