/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.sql.Time;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import org.gvsig.tools.swing.impl.ClearButtonUtils;
import org.gvsig.tools.swing.impl.ContextMenuUtils;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableNumberEditor;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerNumberModel;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerTimeModel;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableTimeEditor;

public class NullableSpinnerUtils {
    public static JSpinner ofIntegers(JSpinner spinner, Integer value, int minimum, int maximum, int stepSize) {
        NullableSpinnerNumberModel model = new NullableSpinnerNumberModel(value, minimum, maximum, stepSize);
        spinner.setModel(model);
        NullableNumberEditor editor = new NullableNumberEditor(spinner, Integer.class);
        JFormattedTextField text = editor.getTextField();
        ContextMenuUtils.setDefaultContextMenu(text);
        spinner.setEditor(editor);
        return spinner;
    }

    public static JSpinner ofNumber(JSpinner spinner, Class valueClass) {
        NullableSpinnerNumberModel model = new NullableSpinnerNumberModel(null);
        spinner.setModel(model);
        NullableNumberEditor editor = new NullableNumberEditor(spinner, valueClass);
        JFormattedTextField text = editor.getTextField();
        ContextMenuUtils.setDefaultContextMenu(text);
        spinner.setEditor(editor);
        return spinner;
    }

    public static JSpinner ofNumber(JSpinner spinner, Number value) {
        NullableSpinnerNumberModel model = new NullableSpinnerNumberModel(value);
        spinner.setModel(model);
        NullableNumberEditor editor = new NullableNumberEditor(spinner, value.getClass());
        JFormattedTextField text = editor.getTextField();
        ContextMenuUtils.setDefaultContextMenu(text);
        spinner.setEditor(editor);
        return spinner;
    }

    public static JSpinner ofTime(JSpinner spinner) {
        return NullableSpinnerUtils.ofTime(spinner, new Time(new Date().getTime()));
    }

    public static JSpinner ofTime(JSpinner spinner, Time value) {
        NullableSpinnerTimeModel sm = new NullableSpinnerTimeModel((Date)value, null, null, 11);
        spinner.setModel(sm);
        NullableTimeEditor editor = new NullableTimeEditor(spinner);
        JFormattedTextField text = editor.getTextField();
        ClearButtonUtils.addClearButton(text);
        ContextMenuUtils.setDefaultContextMenu(text);
        spinner.setEditor(editor);
        return spinner;
    }
}

