/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.searchtoolbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.swing.api.SearchToolbar;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchToolbarImpl
extends JPanel
implements SearchToolbar {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchToolbarImpl.class);
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == SearchToolbarImpl.this.activationKey && e.isControlDown() && e.isAltDown()) {
                SearchToolbarImpl.this.doShowToolbar();
            }
        }
    };
    private JTextComponent text;
    private final JTextField textSearch;
    private final JButton nextButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton closeButton = new JButton();
    private JScrollPane scrollPanel;
    private int direction;
    private int activationKey = 70;

    public SearchToolbarImpl() {
        this.textSearch = new JTextField();
        this.textSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (SearchToolbarImpl.this.direction < 0) {
                            SearchToolbarImpl.this.doPrevious();
                            break;
                        }
                        SearchToolbarImpl.this.doNext();
                        break;
                    }
                    case 27: {
                        SearchToolbarImpl.this.doClose();
                        break;
                    }
                    case 38: 
                    case 40: {
                        SearchToolbarImpl.this.text.requestFocusInWindow();
                        break;
                    }
                }
            }
        });
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.nextButton, (String)"_Search_next", (String)"common-arrow-down", e -> this.doNext(), null);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.previousButton, (String)"_Search_previous", (String)"common-arrow-up", e -> this.doPrevious(), null);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.closeButton, (String)"_Close", (String)"common-form-close", e -> this.doClose(), null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 100.0;
        c.ipady = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.textSearch, c);
        c.weightx = 0.0;
        c.gridx = 1;
        this.add((Component)this.previousButton, c);
        c.gridx = 2;
        this.add((Component)this.nextButton, c);
        c.gridx = 3;
        this.add((Component)this.closeButton, c);
    }

    private void doNext() {
        try {
            String find = this.textSearch.getText().toLowerCase();
            String theText = this.text.getText().toLowerCase();
            int findLength = find.length();
            int currentPosition = this.text.getCaretPosition();
            int pos = theText.indexOf(find, currentPosition);
            if (pos >= 0) {
                Rectangle viewRect = this.text.modelToView(pos);
                this.text.requestFocusInWindow();
                this.text.scrollRectToVisible(viewRect);
                Highlighter highlighter = this.text.getHighlighter();
                highlighter.removeAllHighlights();
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
                highlighter.addHighlight(pos, pos + findLength, painter);
                this.text.setCaretPosition(pos + findLength);
                this.textSearch.requestFocusInWindow();
            }
            this.direction = 1;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't find next", (Throwable)ex);
        }
    }

    private void doPrevious() {
        try {
            int currentPosition = this.text.getCaretPosition();
            if (currentPosition > 0) {
                --currentPosition;
            }
            String find = this.textSearch.getText().toLowerCase();
            int findLength = find.length();
            String theText = this.text.getText().toLowerCase();
            int pos = (theText = theText.substring(0, currentPosition)).lastIndexOf(find, currentPosition);
            if (pos >= 0) {
                Rectangle viewRect = this.text.modelToView(pos);
                this.text.requestFocusInWindow();
                this.text.scrollRectToVisible(viewRect);
                Highlighter highlighter = this.text.getHighlighter();
                highlighter.removeAllHighlights();
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
                highlighter.addHighlight(pos, pos + findLength, painter);
                this.text.setCaretPosition(pos);
                this.textSearch.requestFocusInWindow();
            }
            this.direction = -1;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't find next", (Throwable)ex);
        }
    }

    private void doClose() {
        this.setVisible(false);
        if (this.scrollPanel != null) {
            this.scrollPanel.setColumnHeaderView(null);
        }
        Highlighter highlighter = this.text.getHighlighter();
        highlighter.removeAllHighlights();
        this.text.requestFocusInWindow();
    }

    private void doShowToolbar() {
        if (!this.isVisible()) {
            this.setVisible(true);
            if (this.scrollPanel != null) {
                this.scrollPanel.setColumnHeaderView(this);
            }
        }
        this.textSearch.requestFocusInWindow();
    }

    public void install(JTextComponent text) {
        this.install(text, -1);
    }

    public void install(JTextComponent text, int activationKey) {
        this.setVisible(false);
        this.text = text;
        if (activationKey > 0) {
            this.activationKey = activationKey;
        }
        this.scrollPanel = null;
        try {
            Container comp = text.getParent().getParent();
            if (comp instanceof JScrollPane) {
                this.scrollPanel = (JScrollPane)comp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.scrollPanel == null) {
            this.text.setLayout(new BorderLayout());
            this.text.add((Component)this, "North");
        }
        this.text.addKeyListener(this.keyListener);
    }

    public void uninstall() {
        this.text.removeKeyListener(this.keyListener);
        this.remove(this);
    }
}

