/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.date;

import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.swing.impl.usability.spinner.editor.DataTypesFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullSpinnerHandler {
    private Component txtField = null;
    private final Logger LOG = LoggerFactory.getLogger(NullSpinnerHandler.class);
    private DataTypesFormatter formatter = null;
    private Object curValue = null;
    private Comparable start = null;
    private Comparable end = null;
    private SpinnerModel model = null;
    private boolean isNotFirstTime;
    private boolean valid = true;

    private static int getInitialCalendarField(DynField dynField, Locale loc) {
        DataTypesFormatter formatter = DataTypesFormatter.getInstance(dynField.getType(), dynField.getSubtype(), loc);
        return formatter.getCalendarField();
    }

    public NullSpinnerHandler(DynField field) {
        this(field, Locale.getDefault());
    }

    public NullSpinnerHandler(DynField dynField, Locale loc) {
        this.init(dynField.getType(), dynField.getSubtype(), loc, (Comparable)dynField.getMinValue(), (Comparable)dynField.getMaxValue());
    }

    public NullSpinnerHandler(int type, String subType, Locale loc) {
        this.init(type, subType, new Locale("en"), null, null);
    }

    public Date getDate() {
        if (this.formatter.isDate()) {
            return (Date)this.getValue();
        }
        return null;
    }

    public NullSpinnerDateModel getDateModel() {
        if (this.model == null) {
            this.model = new NullSpinnerDateModel(this, this.start, this.end);
        }
        return (NullSpinnerDateModel)this.model;
    }

    public DataTypesFormatter getDynFieldFormatter() {
        return this.formatter;
    }

    private Comparable getEnd() {
        return this.end;
    }

    public DataTypesFormatter getFormatter() {
        return this.formatter;
    }

    public void initDefaultModel() {
        if (this.model == null) {
            this.model = this.getModel();
        }
    }

    public Object getNextValue() {
        Object next = this.formatter.getNextValue(this.getValue());
        return this.getEnd() == null || this.getEnd().compareTo(next) >= 0 ? next : null;
    }

    public NullSpinnerNumberModel getNumberModel() {
        if (this.model == null) {
            this.model = new NullSpinnerNumberModel(this, this.start, this.end);
        }
        return (NullSpinnerNumberModel)this.model;
    }

    public Object getPreviousValue() {
        Object prev = this.formatter.getPreviousValue(this.getValue());
        return this.getStart() == null || this.getStart().compareTo(prev) <= 0 ? prev : null;
    }

    private Comparable getStart() {
        return this.start;
    }

    public Object getValue() {
        if (this.isFirstTime() && this.curValue == null) {
            if (this.formatter.isDate()) {
                return new Date();
            }
            if (this.isNumber()) {
                return 0;
            }
            return null;
        }
        return this.formatter.parse(this.curValue);
    }

    public Object getValueFromTexField(JFormattedTextField textField) {
        String txt = textField.getText();
        return this.parseOrNull(txt);
    }

    protected void init(int dataType, String subType, Locale loc, Comparable start, Comparable end) {
        this.model = this.getModel(dataType, subType, loc, start, end);
    }

    protected SpinnerModel getModel(int dataType, String subType, Locale loc, Comparable start, Comparable end) {
        this.start = start;
        this.end = end;
        this.formatter = DataTypesFormatter.getInstance(dataType, subType, loc);
        return this.getModel();
    }

    public SpinnerModel getModel(DynField dynField) {
        if (this.formatter.isDate()) {
            SpinnerDateModel dateModel = new SpinnerDateModel();
            dateModel.setStart((Comparable)dynField.getMinValue());
            dateModel.setEnd((Comparable)dynField.getMaxValue());
            return dateModel;
        }
        if (this.formatter.isNumber()) {
            SpinnerNumberModel numModel = new SpinnerNumberModel();
            numModel.setMinimum((Comparable)dynField.getMinValue());
            numModel.setMaximum((Comparable)dynField.getMaxValue());
            numModel.setStepSize(1);
            return numModel;
        }
        SpinnerListModel model = new SpinnerListModel(this.getLabelValues(dynField));
        return model;
    }

    public String[] getLabelValues(DynField dynField) {
        DynObjectValueItem[] items = dynField.getAvailableValues();
        if (items == null || items.length < 1) {
            return new String[0];
        }
        String[] strValues = new String[items.length];
        for (int i = 0; i < strValues.length; ++i) {
            strValues[i] = items[i].getLabel();
        }
        return strValues;
    }

    public SpinnerModel getModel() {
        if (this.model == null) {
            this.model = this.formatter.isDate() ? new NullSpinnerDateModel(this, this.start, this.end) : (this.formatter.isNumber() ? new NullSpinnerNumberModel(this, this.start, this.end) : new SpinnerListModel());
        }
        return this.model;
    }

    public boolean isDate() {
        return this.formatter.isDate();
    }

    private boolean isFirstTime() {
        return !this.isNotFirstTime;
    }

    public boolean isNumber() {
        return this.formatter.isNumber();
    }

    public Object parseOrNull(String txt) {
        try {
            return this.formatter.parse(txt);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setDefaultValueOn(boolean isSet) {
        this.isNotFirstTime = !isSet;
    }

    public void setValue(Object value) {
        if (value instanceof String && ((String)value).equals("")) {
            value = null;
        }
        if (value != null && !this.formatter.isValidType(value)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.curValue = this.formatter.parse(value);
    }

    public JFormattedTextField getTextField() {
        this.model = this.getModel();
        if (this.model instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)((Object)this.model)).getTextField();
        }
        if (this.model instanceof JSpinner.NumberEditor) {
            return ((JSpinner.NumberEditor)((Object)this.model)).getTextField();
        }
        if (this.model instanceof JSpinner.ListEditor) {
            return ((JSpinner.ListEditor)((Object)this.model)).getTextField();
        }
        return null;
    }

    public class NullSpinnerNumberModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = -3645717385964526394L;
        private NullSpinnerHandler handler;

        public NullSpinnerNumberModel(NullSpinnerHandler handler, Comparable minimum, Comparable maximum) {
            super((Number)0, minimum, maximum, (Number)1);
            this.handler = handler;
        }

        public Object format(Object value) {
            return this.getFormatter().format(value);
        }

        public DataTypesFormatter getFormatter() {
            return this.handler.getFormatter();
        }

        public NumberFormat getFormat() {
            return this.getFormatter().getNumberFormatter();
        }

        @Override
        public Object getNextValue() {
            return this.handler.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            return this.handler.getPreviousValue();
        }

        @Override
        public Object getValue() {
            return this.handler.getValue();
        }

        @Override
        public void setValue(Object value) {
            this.handler.setValue(value);
            value = this.handler.getValue();
            if (value != null) {
                super.setValue(value);
            }
            if (!NullSpinnerHandler.this.isFirstTime()) {
                this.fireStateChanged();
            }
        }
    }

    public class NullSpinnerDateModel
    extends SpinnerDateModel {
        private static final long serialVersionUID = -400734052278449520L;
        private NullSpinnerHandler handler;

        public NullSpinnerDateModel(NullSpinnerHandler handler, Comparable start, Comparable end) {
            super(new Date(), start, end, handler.getFormatter().getCalendarField());
            this.handler = handler;
            this.setValue(null);
        }

        public Object format(Object value) {
            return this.handler.getFormatter().format(value);
        }

        @Override
        public int getCalendarField() {
            return super.getCalendarField();
        }

        public SimpleDateFormat getFormat() {
            return NullSpinnerHandler.this.getFormatter().getDateFormatter();
        }

        @Override
        public Object getNextValue() {
            Object next = this.handler.getNextValue();
            return next;
        }

        @Override
        public Object getPreviousValue() {
            Object prev = this.handler.getPreviousValue();
            return prev;
        }

        @Override
        public Object getValue() {
            return this.handler.getValue();
        }

        @Override
        public void setCalendarField(int calendarField) {
            try {
                super.setCalendarField(calendarField);
            }
            catch (IllegalArgumentException e) {
                if (this.getValue() != null) {
                    throw new IllegalArgumentException(e);
                }
                this.fireStateChanged();
            }
            this.handler.getFormatter().setCalendarField(this.getCalendarField());
        }

        @Override
        public void setValue(Object value) {
            Object oldValue = this.getValue();
            this.handler.setValue(value);
            if (value != null) {
                super.setValue(this.handler.getValue());
            } else if (oldValue == null) {
                if (value != null) {
                    this.fireStateChanged();
                }
            } else if (!oldValue.equals(value)) {
                this.fireStateChanged();
            }
        }
    }
}

