/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.windowmanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.windowmanager.DefaultDialog;

public class DefaultWindowManager
implements WindowManager_v2 {
    public void showWindow(JComponent component, String title, WindowManager.MODE mode) {
        this.showWindow(component, title, mode, null, 0);
    }

    public void showWindow(JComponent component, String title, WindowManager.MODE mode, Image icon) {
        this.showWindow(component, title, mode, icon, 0);
    }

    public void showWindow(JComponent component, String title, WindowManager.MODE mode, Image icon, int flags) {
        this.showWindow(component, title, mode, icon, flags, null);
    }

    private void showWindow(JComponent component, String title, WindowManager.MODE mode, Image icon, int flags, Component relativeTo) {
        switch (mode) {
            case TOOL: 
            case WINDOW: 
            case SDIWINDOW: {
                MyFrame frame = new MyFrame(title);
                frame.setContentPane(component);
                component.addComponentListener(frame);
                if (icon != null) {
                    frame.setIconImage(icon);
                }
                frame.pack();
                frame.setLocationRelativeTo(relativeTo);
                frame.setVisible(true);
                break;
            }
            case DIALOG: {
                MyJDialog dialog = new MyJDialog(title, true);
                dialog.setContentPane(component);
                component.addComponentListener(dialog);
                if (icon != null) {
                    dialog.setIconImage(icon);
                }
                dialog.pack();
                dialog.setLocationRelativeTo(relativeTo);
                dialog.setVisible(true);
            }
        }
    }

    public void showWindow(JComponent componet, String tittle, WindowManager.MODE mode, Map<String, Object> props) {
        Object relativeTo_o;
        Object icon_o;
        if (props == null || props.isEmpty()) {
            this.showWindow(componet, tittle, mode);
            return;
        }
        int flags = 0;
        Image icon = null;
        Component relativeTo = null;
        Object flags_o = props.get("flags");
        if (flags_o instanceof Number) {
            flags = ((Number)flags_o).intValue();
        }
        if ((icon_o = props.get("icon")) instanceof Image) {
            icon = (Image)icon_o;
        }
        if ((relativeTo_o = props.get("relativeTo")) instanceof Component) {
            relativeTo = (Component)relativeTo_o;
        }
        this.showWindow(componet, tittle, mode, icon, flags, relativeTo);
    }

    public Dialog createDialog(JComponent component, String title, String header, int buttons) {
        DefaultDialog dialog = new DefaultDialog(component, title, header, buttons);
        dialog.setWindowManager((WindowManager)this);
        return dialog;
    }

    public class MyJDialog
    extends JDialog
    implements ComponentListener {
        public MyJDialog(String title, boolean modal) {
            super((Frame)null, title, modal);
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }

    public class MyFrame
    extends JFrame
    implements ComponentListener {
        public MyFrame(String title) {
            super(title);
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
            this.setVisible(false);
            this.dispose();
        }

        public void setComponentPane(Component component) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }
}

