/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml.simplereaders;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.CRSUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.store.gml.GMLStoreParameters;
import org.gvsig.fmap.dal.store.gml.virtualrows.GfsFile;
import org.gvsig.fmap.dal.store.gml.virtualrows.XMLFileAsList;
import org.gvsig.fmap.dal.store.gml.virtualrows.XmlCommons;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderUtils;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.AbstractSimpleReader;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.GetItemWithSize64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLReader
extends AbstractSimpleReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GMLReader.class);
    private XMLFileAsList gml;
    private int columns;
    private String[] header;
    private int currentElement = 0;
    private final GMLStoreParameters parameters;
    private GfsFile gfs;

    public GMLReader(Reader reader, GMLStoreParameters theParameters) throws IOException {
        File gmlFile = theParameters.getFile();
        File gfsFile = new File(FilenameUtils.removeExtension((String)gmlFile.getAbsolutePath()) + ".gfs");
        this.gfs = new GfsFile();
        if (gfsFile.exists() && SimpleReaderUtils.isFileNewer((File)gfsFile, (File)gmlFile)) {
            this.gfs.load(gfsFile);
        } else {
            this.gfs.fetch(gmlFile);
            this.gfs.save(gfsFile);
        }
        this.gml = null;
        this.columns = -1;
        this.header = null;
        this.parameters = theParameters;
    }

    private XMLFileAsList getGml() {
        if (this.gml == null) {
            this.gml = (XMLFileAsList)this.getVirtualRows(SimpleTaskStatus.FAKE_STATUS);
        }
        return this.gml;
    }

    private IProjection toProjection(String srs) {
        IProjection proj;
        try {
            String crs = CRSUtils.ogcProjectionToAuthorityAndCode((String)srs);
            proj = CRSFactory.getCRS((String)crs);
        }
        catch (Throwable th) {
            return null;
        }
        return proj;
    }

    public String[] getHeader() throws IOException {
        if (this.header == null) {
            Collection<GfsFile.GeometryPropertyDefn> geoms = this.gfs.getGeometryElements();
            String[] theHeader = new String[this.gfs.size() + (geoms == null ? 0 : geoms.size())];
            int i = 0;
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            for (Object item : this.gfs) {
                DataType dataType = dataTypesManager.get(((GfsFile.PropertyDefn)item).getType());
                theHeader[i++] = ((GfsFile.PropertyDefn)item).getName() + "/" + dataType.getName();
            }
            if (geoms != null && !geoms.isEmpty()) {
                if (this.parameters.getGeometryCombineMode() == 1) {
                    String srs = null;
                    for (GfsFile.GeometryPropertyDefn geom : geoms) {
                        if (srs == null) {
                            srs = geom.getSrs();
                            continue;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)srs, (CharSequence)geom.getSrs())) continue;
                        srs = null;
                        break;
                    }
                    IProjection proj = null;
                    if (srs != null) {
                        proj = this.toProjection(srs);
                    }
                    theHeader[i++] = proj == null ? this.getGeometryAttributeName() + "/Geometry" : this.getGeometryAttributeName() + "/Geometry/set/srs=" + proj.getAbrev().replace(":", "@");
                } else {
                    for (GfsFile.GeometryPropertyDefn geom : geoms) {
                        GeometryType geomType = geom.getGeometryType();
                        String geomType_s = "/set/geomtype=" + GeometryUtils.getGeometryTypeName((int)geomType.getType()) + ":" + GeometryUtils.getGeometrySubtypeName((int)geomType.getSubType());
                        IProjection srs = this.toProjection(geom.getSrs());
                        if (srs == null) {
                            theHeader[i++] = geom.getName() + "/Geometry" + geomType_s;
                            continue;
                        }
                        theHeader[i++] = geom.getName() + "/Geometry/set/srs=" + srs.getAbrev().replace(":", "@") + geomType_s;
                    }
                }
            }
            this.header = theHeader;
        }
        return this.header;
    }

    private String getGeometryAttributeName() {
        NamesTranslator translator = NamesTranslator.createBaseTranslator();
        for (GfsFile.PropertyDefn item : this.gfs) {
            translator.addSource(item.getName());
        }
        String s = translator.getSuggestion("Geometry");
        return s;
    }

    public int getColumnsCount() throws IOException {
        if (this.columns <= 0) {
            this.columns = this.getHeader().length;
        }
        return this.columns;
    }

    public List<String> read() throws IOException {
        List<String> values = this.read(this.currentElement);
        if (values == null) {
            return null;
        }
        ++this.currentElement;
        return values;
    }

    public List<String> read(int rowNumber) throws IOException {
        if ((long)rowNumber < this.getGml().size64()) {
            Object values = this.getGml().get64(rowNumber);
            return values;
        }
        return null;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.gml);
        this.gml = null;
        this.gfs = null;
    }

    public List<String> skip(int lines) throws IOException {
        this.currentElement += lines;
        if ((long)this.currentElement > this.getGml().size64()) {
            return null;
        }
        return this.read(this.currentElement);
    }

    public int getLine() {
        if (this.getGml() == null) {
            return 0;
        }
        return this.currentElement;
    }

    public List<String> nextRowValues() {
        try {
            return this.read();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetItemWithSize64<List<String>> getVirtualRows(SimpleTaskStatus status) {
        try {
            File gmlIdx;
            XMLFileAsList x;
            File gmlFile = this.parameters.getFile();
            String charset = SimpleReaderStoreParameters.getCharset((DynObject)this.parameters);
            if (StringUtils.isBlank((CharSequence)charset)) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(gmlFile);
                    charset = XmlCommons.detectCharsetName(fis);
                }
                catch (Throwable t) {
                    try {
                        charset = "UTF-8";
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            if (!(x = new XMLFileAsList(gmlFile, Charset.forName(charset), this.gfs.getBaseElementPath(), this.gfs.getGeometryElementPaths(), this.gfs.getPropertiesPaths())).loadIndex(gmlIdx = new File(FilenameUtils.removeExtension((String)gmlFile.getAbsolutePath()) + ".gmlidx"), status)) {
                x.createIndex(gmlIdx, status);
            }
            x.setCombineMode(this.parameters.getGeometryCombineMode());
            return x;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't get virtual rows", ex);
        }
    }
}

