/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.spi.operations;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.operations.SpecifiedBandsOperation;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractOperation;

public abstract class AbstractSpecifiedBandsOperation
extends AbstractOperation
implements SpecifiedBandsOperation {
    private List<Integer> bandsToProcess;

    public AbstractSpecifiedBandsOperation(OperationFactory factory) {
        super(factory);
    }

    public List<Integer> getBandsToProcess() {
        return this.bandsToProcess;
    }

    @Override
    public void preProcess() throws BufferOperationException {
        super.preProcess();
        if (this.getParameters().getDynClass().getDynField("bands_to_process") != null) {
            this.bandsToProcess = (List)this.getParameters().getDynValue("bands_to_process");
        }
        if (this.bandsToProcess == null) {
            this.bandsToProcess = new ArrayList<Integer>(this.getInputBuffer().getBandCount());
        }
        if (this.bandsToProcess.isEmpty()) {
            for (int i = 0; i < this.getInputBuffer().getBandCount(); ++i) {
                this.bandsToProcess.add(i);
            }
        }
    }

    protected boolean isProcessableBand(int band) {
        return this.bandsToProcess.contains(band);
    }

    @Override
    public void process() throws ProcessingOperationException {
        super.process();
    }

    @Override
    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    protected List<NoData> getProcessableBandNoDatas() {
        int bands = this.getInputBuffer().getBandCount();
        ArrayList<NoData> noDatas = new ArrayList<NoData>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            noDatas.add(this.getInputBuffer().getBandNoData()[band]);
        }
        return noDatas;
    }

    protected NoData[] getProcessableBandNoDatasAsArray() {
        List<NoData> l = this.getProcessableBandNoDatas();
        NoData[] noDatas = l.toArray(new NoData[l.size()]);
        return noDatas;
    }

    protected List<Integer> getProcessableBandTypes() {
        int bands = this.getInputBuffer().getBandCount();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            types.add(this.getInputBuffer().getBandTypes()[band]);
        }
        return types;
    }

    protected int[] getProcessableBandTypesAsArray() {
        int[] types = this.getTypesAsArray(this.getProcessableBandTypes());
        return types;
    }

    protected int[] getTypesAsArray(List<Integer> theTypes) {
        int[] types = new int[theTypes.size()];
        int n = 0;
        for (Integer type : theTypes) {
            types[n++] = type;
        }
        return types;
    }
}

