/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.lib.impl.regionalpha;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.raster.roimask.lib.impl.regionalpha.RegionAlphaByteFilter;
import org.gvsig.raster.roimask.lib.impl.regionalpha.RegionAlphaFilter;
import org.gvsig.raster.roimask.lib.impl.regionalpha.RegionAlphaUI;

public class RegionAlphaListManager
extends AbstractRasterFilterManager {
    public static String ID = "RegionAlpha";

    public RegionAlphaListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, RegionAlphaListManager.class, RegionAlphaUI.class);
    }

    public String getManagerID() {
        return ID;
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("regionalpha") == 0) {
            return RegionAlphaFilter.class;
        }
        return null;
    }

    public void addRegionAlphaFilter(boolean[] selectedROI, int alpha, Boolean inverse) throws FilterTypeException {
        RegionAlphaByteFilter filter = new RegionAlphaByteFilter();
        if (filter != null) {
            filter.addParam("inverse", inverse);
            filter.addParam("alpha", alpha);
            filter.addParam("selected_roi", selectedROI);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(RegionAlphaFilter.class);
        return filters;
    }

    public RasterFilter createFilter(Params params) {
        boolean[] selectedROI = (boolean[])params.getParamById("selected_roi").getDefaultValue();
        Boolean inverse = (Boolean)params.getParamById("inverse").getDefaultValue();
        Integer alpha = (Integer)params.getParamById("Alpha").getDefaultValue();
        RegionAlphaByteFilter filter = new RegionAlphaByteFilter();
        filter.addParam("selected_roi", selectedROI);
        filter.addParam("inverse", inverse);
        filter.addParam("alpha", alpha);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(RegionAlphaFilter.class, params);
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (classFilter.equals(RegionAlphaFilter.class)) {
            int i;
            boolean[] selectedROI = null;
            Boolean inverse = new Boolean(false);
            int alpha = 255;
            Params paramsUI = null;
            for (i = 0; i < params.getNumParams(); ++i) {
                if (params.getParam(i).getId().equals("Panel") && params.getParam(i).getDefaultValue() instanceof RegistrableFilterListener) {
                    paramsUI = ((RegistrableFilterListener)params.getParam(i).getDefaultValue()).getParams();
                }
                if (!params.getParam(i).getId().equals("Alpha") || !(params.getParam(i).getDefaultValue() instanceof Integer)) continue;
                alpha = (Integer)params.getParam(i).getDefaultValue();
            }
            if (paramsUI != null) {
                for (i = 0; i < paramsUI.getNumParams(); ++i) {
                    if (paramsUI.getParam(i).getId().equals("selected_roi")) {
                        selectedROI = (boolean[])paramsUI.getParam(i).getDefaultValue();
                    }
                    if (!paramsUI.getParam(i).getId().equals("inverse")) continue;
                    inverse = (Boolean)paramsUI.getParam(i).getDefaultValue();
                }
            }
            this.addRegionAlphaFilter(selectedROI, alpha, inverse);
        }
    }
}

