/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.lib.impl;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFWriter;
import org.gvsig.pdf.lib.impl.DefaultPDFDocument;

public class DefaultPDFWriter
implements PDFWriter {
    private PDRectangle pageSize;
    private PdfBoxGraphics2D graphics;
    private PDDocument document;
    private byte[] data;

    public void open(int pageSize) {
        switch (pageSize) {
            case 4: {
                this.pageSize = PDRectangle.A4;
                break;
            }
            case 5: {
                this.pageSize = PDRectangle.A5;
                break;
            }
            case 2: {
                this.pageSize = PDRectangle.LEGAL;
                break;
            }
            case 1: {
                this.pageSize = PDRectangle.LETTER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value of page format");
            }
        }
        this.close();
        this.data = null;
    }

    public void close() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        if (this.document != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.document.save((OutputStream)os);
                this.data = os.toByteArray();
            }
            catch (IOException ex) {
                this.data = null;
            }
            this.document = null;
        }
    }

    public Graphics2D getGraphics2D() {
        try {
            if (this.graphics != null) {
                return this.graphics;
            }
            if (this.document == null) {
                this.document = new PDDocument();
                PDPage page = new PDPage(this.pageSize);
                this.document.addPage(page);
            }
            this.graphics = new PdfBoxGraphics2D(this.document, this.pageSize);
            return this.graphics;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create graphics.", ex);
        }
    }

    public float getWidth() {
        return this.pageSize.getWidth();
    }

    public float getHeight() {
        return this.pageSize.getHeight();
    }

    public byte[] toByteArray() {
        if (this.document != null) {
            this.close();
        }
        return this.data;
    }

    public PDFDocument toDocument() {
        if (this.document != null) {
            this.close();
        }
        DefaultPDFDocument theDocument = new DefaultPDFDocument();
        theDocument.setSource(this.data);
        return theDocument;
    }
}

