/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_Force3D
extends DeterministicScalarFunction {
    public ST_Force3D() {
        this.addProperty("remarks", "Forces the geometries into XYZ mode. This is an alias for ST_Force_3DZ.\n If a geometry has no Z component, then a 0 Z coordinate is tacked on.");
    }

    public String getJavaStaticMethod() {
        return "force3D";
    }

    public static Geometry force3D(Geometry geom) {
        if (geom == null) {
            return null;
        }
        Geometry outPut = (Geometry)geom.clone();
        outPut.apply(new CoordinateSequenceFilter(){
            private boolean done = false;

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return this.done;
            }

            public void filter(CoordinateSequence seq, int i) {
                Coordinate coord = seq.getCoordinate(i);
                double z = coord.z;
                if (Double.isNaN(z)) {
                    seq.setOrdinate(i, 2, 0.0);
                }
                if (i == seq.size()) {
                    this.done = true;
                }
            }
        });
        return outPut;
    }
}

