/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import com.vividsolutions.jts.algorithm.MinimumBoundingCircle;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_BoundingCircleCenter
extends DeterministicScalarFunction {
    public ST_BoundingCircleCenter() {
        this.addProperty("remarks", "Compute the minimum bounding circle center of a geometry.This function is more precise than the conjunction of ST_CENTROID and ST_BoundingCircle");
    }

    public String getJavaStaticMethod() {
        return "getCircumCenter";
    }

    public static Point getCircumCenter(Geometry geometry) {
        if (geometry == null || geometry.getNumPoints() == 0) {
            return null;
        }
        return geometry.getFactory().createPoint(new MinimumBoundingCircle(geometry).getCentre());
    }
}

