/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.swing.impl;

import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.raster.roimask.swing.ROIMaskData;
import org.gvsig.raster.roimask.swing.impl.ROIMaskPanelImpl;

public class ROIMaskDataImpl
implements ROIMaskData {
    private ROIMaskPanelImpl panel = null;
    private Object inputLyr = null;

    public ROIMaskDataImpl(ROIMaskPanelImpl panel) {
        this.panel = panel;
    }

    public Object getInputLayer() {
        return this.inputLyr;
    }

    public void setInputLayer(Object obj) {
        this.inputLyr = obj;
    }

    public int getAlpha() {
        double controlValue = this.panel.getSlider().getValue();
        return (int)(controlValue * 255.0 / 100.0);
    }

    public boolean isInverse() {
        return this.panel.getInverse().isSelected();
    }

    public void setValueNoData(double value) {
        this.panel.setValueNoData(value);
    }

    public void clearROIs() throws NotInitializeException {
        this.panel.clearTable();
    }

    public void addROI(Object[] roi) throws NotInitializeException {
        this.panel.addRow(roi);
    }

    public double getValueNoData() {
        try {
            return new Double(this.panel.getValueNoData().getValue());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public boolean[] getROIsSelected() {
        try {
            boolean[] result = new boolean[this.panel.getTableContainer().getRowCount()];
            for (int i = 0; i < this.panel.getTableContainer().getRowCount(); ++i) {
                result[i] = (Boolean)this.panel.getTableContainer().getModel().getValueAt(i, 0);
            }
            return result;
        }
        catch (NotInitializeException e) {
            return null;
        }
    }
}

