/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app.server;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;

public class VCSGisJettyServerUtils {
    public static final int SERVER_PORT = 9810;

    public static Server createServer(int port, String shutdownpass, String rootpath) {
        Server server = new Server(port);
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setResourceBase(rootpath);
        resource_handler.setDirAllowed(true);
        resource_handler.setDirectoriesListed(true);
        ServletContextHandler context = new ServletContextHandler(0);
        VCSGisManager vcsGisManager = VCSGisLocator.getManager();
        context.addServlet(vcsGisManager.getServletClass("repoinfo"), "/repoinfo");
        context.addServlet(vcsGisManager.getServletClass("entities"), "/entities");
        context.addServlet(vcsGisManager.getServletClass("commit"), "/commit");
        context.addServlet(vcsGisManager.getServletClass("checkout"), "/checkout");
        context.addServlet(vcsGisManager.getServletClass("history"), "/history");
        context.addServlet(vcsGisManager.getServletClass("update"), "/update");
        context.addServlet(vcsGisManager.getServletClass("authenticate"), "/authenticate");
        context.addServlet(vcsGisManager.getServletClass("users"), "/users");
        context.addServlet(vcsGisManager.getServletClass("topologyplans"), "/topologyplans");
        context.addServlet(vcsGisManager.getServletClass("rowcreate"), "/rowcreate");
        context.addServlet(vcsGisManager.getServletClass("rowupdate"), "/rowupdate");
        context.addServlet(vcsGisManager.getServletClass("rowdelete"), "/rowdelete");
        context.addServlet(vcsGisManager.getServletClass("rowisoutofdate"), "/rowisoutofdate");
        context.addServlet(vcsGisManager.getServletClass("listwc"), "/listwc");
        context.addServlet(vcsGisManager.getServletClass("preparewc"), "/preparewc");
        context.addServlet(vcsGisManager.getServletClass("simplewfs"), "/simplewfs");
        context.addServlet(vcsGisManager.getServletClass("hooktest"), "/hooktest");
        context.addServlet(vcsGisManager.getServletClass("log"), "/log");
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)resource_handler);
        handlers.addHandler((Handler)context);
        if (shutdownpass != null) {
            handlers.addHandler((Handler)new ShutdownHandler(shutdownpass));
        }
        server.setHandler((Handler)handlers);
        return server;
    }
}

