/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app.server;

import java.awt.Cursor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Server;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.URLUtils;
import org.gvsig.vcsgis.app.server.VCSGisJettyServerUtils;
import org.gvsig.vcsgis.app.server.VCSGisServerPanelView;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.server.VCSGisServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisServerPanel
extends VCSGisServerPanelView
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisServerPanel.class);
    private Server server = null;
    private PickerController<JDBCServerExplorerParameters> connectionPicker;
    private final File rootFolder;
    private FilePickerController debugFilePicker;
    private Writer lastDebugWriter;
    private Map<JDBCServerExplorerParameters, Boolean> validRepsitoties;

    public VCSGisServerPanel(File rootFolder) {
        this.rootFolder = rootFolder;
        this.initComponents();
    }

    private boolean isRepository(JDBCServerExplorerParameters connection) {
        Boolean valid;
        if (this.validRepsitoties == null) {
            this.validRepsitoties = new HashMap<JDBCServerExplorerParameters, Boolean>();
        }
        if ((valid = this.validRepsitoties.get(connection)) == null) {
            valid = VCSGisLocator.getManager().isRepository(connection);
            this.validRepsitoties.put(connection, valid);
        }
        return valid;
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblDatabase);
        swingManager.translate(this.lblMessages);
        swingManager.translate(this.lblPort);
        swingManager.translate((AbstractButton)this.btnRestart);
        swingManager.translate((AbstractButton)this.btnStop);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtPort);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtLog);
        IntegerDocumentFilter.install((JTextField)this.txtPort);
        this.btnAddConnection.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRestart.setCursor(Cursor.getPredefinedCursor(12));
        this.btnStop.setCursor(Cursor.getPredefinedCursor(12));
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnections, this.btnAddConnection);
        this.debugFilePicker = swingManager.createFilePickerController((JTextComponent)this.txtDebugFile, this.btnDebugFile);
        this.debugFilePicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VCSGisServerPanel.this.doChangeDebugFile();
            }
        });
        this.btnRestart.addActionListener(e -> this.doRestart());
        this.btnStop.addActionListener(e -> this.doStop());
        this.txtPort.setText(String.valueOf(9810));
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)100);
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String iconName = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (theme.exists(iconName)) {
            return theme.get(iconName);
        }
        return super.loadImage(imageName);
    }

    private void message(String msg) {
        Timestamp tm = new Timestamp(new Date().getTime());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.txtLog.append(df.format(tm));
        this.txtLog.append(" - ");
        this.txtLog.append(msg);
        this.txtLog.append("\n");
        this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
    }

    private int getPort() {
        return IntegerDocumentFilter.getValue((JTextField)this.txtPort);
    }

    private JDBCServerExplorerParameters getServerExplorerParameters() {
        JDBCServerExplorerParameters params = (JDBCServerExplorerParameters)this.connectionPicker.get();
        if (!this.isRepository(params)) {
            return null;
        }
        return params;
    }

    private void doRestart() {
        JDBCServerExplorerParameters connectionParams = this.getServerExplorerParameters();
        if (connectionParams == null) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("Seleccione una conexion valida para reiniciar el servidor.", "Atenci\u00f3n", 2);
            return;
        }
        if (this.server != null) {
            this.message("Stoping server...");
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't stop VCSGis Server", (Throwable)ex);
                this.message("Error stoping server (" + ex.getMessage() + ").");
                return;
            }
            this.server = null;
        }
        URL config_url = this.getClass().getResource("/WEB-INF/vcsgisserver.config");
        ConsoleWriter consoleWriter = new ConsoleWriter(this.txtLog);
        VCSGisServerUtils.setConsoleWriter((Writer)consoleWriter);
        VCSGisServerUtils.setConfiguration((URL)config_url);
        VCSGisServerUtils.setConnectionParameters((JDBCServerExplorerParameters)connectionParams);
        VCSGisServerUtils.writeConfiguration((URL)config_url);
        this.message("Config file: " + URLUtils.toFile((URL)config_url).getAbsolutePath());
        this.message("Creating server...");
        this.server = VCSGisJettyServerUtils.createServer(this.getPort(), null, this.rootFolder.getAbsolutePath());
        this.message("Server at: http://localhost:" + this.getPort());
        this.message("Root at: " + this.rootFolder.getAbsolutePath());
        this.message("Starting server with repository " + connectionParams.getUrl() + "...");
        try {
            this.server.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't start server.", (Throwable)ex);
            this.message("Can't start server (" + ex.getMessage() + ").");
        }
    }

    private void doStop() {
        if (this.server == null) {
            this.message("Server already stoped.");
            return;
        }
        try {
            this.message("Stoping server....");
            this.server.stop();
            this.message("Server stoped.");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't stop server.", (Throwable)ex);
            this.message("Can't stop server (" + ex.getMessage() + ").");
        }
    }

    private void doChangeDebugFile() {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        File f = null;
        try {
            Writer writer = manager.getWriterForProtocolDebugging();
            if (writer != null) {
                writer.flush();
            }
            manager.setWriterForProtocolDebugging(null);
            if (this.lastDebugWriter != null) {
                this.lastDebugWriter.close();
                this.lastDebugWriter = null;
            }
            if ((f = (File)this.debugFilePicker.get()) != null) {
                this.lastDebugWriter = new FileWriter(f);
                manager.setWriterForProtocolDebugging(this.lastDebugWriter);
            }
        }
        catch (Exception ex) {
            this.message("Can't set debug file " + Objects.toString(f));
            LOGGER.warn("Can't set debug file " + Objects.toString(f));
            IOUtils.closeQuietly((Writer)this.lastDebugWriter);
            manager.setWriterForProtocolDebugging(null);
            this.lastDebugWriter = null;
        }
    }

    private static class ConsoleWriter
    extends Writer {
        private final JTextArea console;
        private StringBuilder buffer = new StringBuilder();
        private boolean addprefix;
        private final SimpleDateFormat df;

        public ConsoleWriter(JTextArea console) {
            this.console = console;
            this.addprefix = true;
            this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                char c = cbuf[i];
                if (this.addprefix) {
                    Timestamp tm = new Timestamp(new Date().getTime());
                    this.buffer.append(this.df.format(tm));
                    this.buffer.append(" - ");
                    this.addprefix = false;
                }
                this.buffer.append(c);
                if (c != '\n') continue;
                this.flushLine();
                this.addprefix = true;
            }
        }

        private void flushLine() throws IOException {
            try {
                String s = this.buffer.toString();
                this.buffer = new StringBuilder();
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(() -> {
                        this.console.append(s);
                        this.console.setCaretPosition(this.console.getDocument().getLength());
                    });
                    return;
                }
                this.console.append(s);
                this.console.setCaretPosition(this.console.getDocument().getLength());
            }
            catch (Exception ex) {
                LOGGER.warn("Can't flush console writer.", (Throwable)ex);
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

