/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation;

import java.awt.BorderLayout;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.gui.beans.wizard.WizardPanel;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.swing.api.creation.MakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.wizard.AdvancedModeSelectionWizard;
import org.gvsig.installer.swing.impl.creation.wizard.AntScriptWizard;
import org.gvsig.installer.swing.impl.creation.wizard.PackageInfoWizard;
import org.gvsig.installer.swing.impl.creation.wizard.ProgressWizard;
import org.gvsig.installer.swing.impl.creation.wizard.SelectFilesWizard;
import org.gvsig.installer.swing.impl.creation.wizard.SelectOutputFileWizard;
import org.gvsig.installer.swing.impl.creation.wizard.SelectPlugintoInstallWizard;
import org.gvsig.installer.swing.impl.wizard.AbstractInstallerWizardPanel;
import org.gvsig.tools.locator.LocatorException;

public class DefaultMakePluginPackageWizard
extends AbstractInstallerWizardPanel
implements MakePluginPackageWizard,
WizardPanel {
    private static final long serialVersionUID = 9205891710214122265L;
    private MakePluginPackageService makePluginPackageService = null;
    private OutputStream outputStream = null;
    private OutputStream indexOutputStream;
    private PackageInfo selectedPackageInfo = null;
    private File originalPluginFolder = null;
    private AdvancedModeSelectionWizard advancedModeSelectionWizard = null;
    private AntScriptWizard antScriptWizard = null;
    private PackageInfoWizard pluginDescriptionWizard = null;
    private ProgressWizard progressWizard = null;
    private SelectFilesWizard selectFilesWizard = null;
    private SelectOutputFileWizard selectOutputFileWizard = null;
    private SelectPlugintoInstallWizard selectPlugintoInstallWizard = null;
    private URL downloadURL;

    public DefaultMakePluginPackageWizard(File applicationFolder, File installFolder) throws LocatorException, MakePluginPackageServiceException {
        super(applicationFolder, installFolder);
        URL iconURL = this.getClass().getClassLoader().getResource("images/makepluginpackageicon.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.advancedModeSelectionWizard = new AdvancedModeSelectionWizard(this);
        this.antScriptWizard = new AntScriptWizard(this);
        this.pluginDescriptionWizard = new PackageInfoWizard(this);
        this.progressWizard = new ProgressWizard(this);
        this.selectFilesWizard = new SelectFilesWizard(this);
        this.selectOutputFileWizard = new SelectOutputFileWizard(this);
        this.selectPlugintoInstallWizard = new SelectPlugintoInstallWizard(this);
        this.addWizards();
        this.setFinishButtonEnabled(false);
        this.setLayout(new BorderLayout());
        super.initComponents();
        this.makePluginPackageService = InstallerLocator.getInstallerManager().getMakePluginPackageService();
        this.selectPlugintoInstallWizard.setPluginsDirectory(this.makePluginPackageService);
        this.selectFilesWizard.setApplicationDirectory(applicationFolder);
    }

    public MakePluginPackageService getMakePluginPackageService() {
        return this.makePluginPackageService;
    }

    private void addWizards() {
        this.addOptionPanel(this.selectPlugintoInstallWizard);
        this.addOptionPanel(this.pluginDescriptionWizard);
        this.addOptionPanel(this.advancedModeSelectionWizard);
        this.addLastWizards();
    }

    private void addLastWizards() {
        this.addOptionPanel(this.selectOutputFileWizard);
        this.addOptionPanel(this.progressWizard);
    }

    private void addAdvancedWizards() {
        this.addOptionPanel(this.selectFilesWizard);
        this.addOptionPanel(this.antScriptWizard);
    }

    public void setAdvancedModeSelected(boolean advancedModeSelected) {
        for (int i = this.getWizardComponents().getWizardPanelList().size() - 1; i >= 3; --i) {
            this.getWizardComponents().removeWizardPanel(i);
        }
        if (advancedModeSelected) {
            this.addAdvancedWizards();
        }
        this.addLastWizards();
    }

    public MakePluginPackageService getInstallerCreationService() {
        return this.makePluginPackageService;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getIndexOutputStream() {
        return this.indexOutputStream;
    }

    public void setIndexOutputStream(OutputStream outputStream) {
        this.indexOutputStream = outputStream;
    }

    public PackageInfo getSelectedPackageInfo() {
        return this.selectedPackageInfo;
    }

    public void setSelectedPackageInfo(PackageInfo selectedPackageInfo) {
        this.selectedPackageInfo = selectedPackageInfo;
    }

    public void setOriginalPluginFolder(File originalPluginFolder) {
        this.originalPluginFolder = originalPluginFolder;
    }

    public File getOriginalPluginFolder() {
        return this.originalPluginFolder;
    }

    public void setDownloadURL(URL downloadURL) {
        this.downloadURL = downloadURL;
    }

    public URL getDownloadURL() {
        return this.downloadURL;
    }

    public JComponent asJComponent() {
        return this;
    }
}

