/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.panel.SelectFilesPanel;

public class SelectFilesWizard
extends SelectFilesPanel
implements OptionPanel {
    private static final long serialVersionUID = 1645239143301238773L;
    private DefaultMakePluginPackageWizard installerCreationWizard;

    public SelectFilesWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_files_to_copy");
    }

    public void lastPanel() {
    }

    public void nextPanel() {
        PackageInfo packageInfo = this.installerCreationWizard.getSelectedPackageInfo();
        packageInfo.clearFilesToCopy();
        List<File> selectedFiles = this.getSelectedFiles();
        for (int i = 0; i < selectedFiles.size(); ++i) {
            packageInfo.addFileToCopy(selectedFiles.get(i));
        }
    }

    public void updatePanel() {
        PackageInfo packageInfo;
        String msg;
        int resp;
        InstallerManager manager = InstallerLocator.getInstallerManager();
        String pluginName = this.installerCreationWizard.getSelectedPackageInfo().getCode();
        File pluginLocation = manager.getAddonFolder(pluginName);
        File folder = null;
        if (pluginLocation != null) {
            String path = pluginLocation.getAbsolutePath() + File.separator + "install" + File.separator + "files";
            folder = new File(path);
        }
        if (folder != null && folder.exists() && folder.isDirectory() && (resp = JOptionPane.showConfirmDialog(null, msg = Messages.getText((String)"_the_folder_install/files_already_exists_do_you_want_to_delete_it_before_proceeding?"), Messages.getText((String)"_select_an_option"), 0)) == 0 && !(packageInfo = this.installerCreationWizard.getSelectedPackageInfo()).removeFilesFolder(folder)) {
            JOptionPane.showMessageDialog(null, Messages.getText((String)"_Couldn't_delete_the_directory"));
        }
    }
}

