/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel.renderers;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.swing.impl.execution.panel.model.PackagesTableModel;

public class OsAndArchitectureCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3767874502044161245L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        URL resource;
        JLabel check = new JLabel();
        PackagesTableModel.PackageOsAndArchitecture osArch = (PackagesTableModel.PackageOsAndArchitecture)value;
        if ("all".equalsIgnoreCase(osArch.osfamily)) {
            return check;
        }
        String oslabel = osArch.osfamily;
        if ("lin".equalsIgnoreCase(osArch.osfamily)) {
            oslabel = "Linux";
            if (!StringUtils.isEmpty((CharSequence)osArch.osname)) {
                oslabel = oslabel + " " + osArch.osname;
                if (!StringUtils.isEmpty((CharSequence)osArch.osversion)) {
                    oslabel = oslabel + " " + osArch.osversion;
                }
            }
        } else if ("darwin".equalsIgnoreCase(osArch.osfamily)) {
            oslabel = "Darwin";
            if (!StringUtils.isEmpty((CharSequence)osArch.osname)) {
                oslabel = oslabel + " " + osArch.osname;
                if (!StringUtils.isEmpty((CharSequence)osArch.osversion)) {
                    oslabel = oslabel + " " + osArch.osversion;
                }
            }
        } else if ("win".equalsIgnoreCase(osArch.osfamily)) {
            oslabel = "Windows";
        }
        String tooltip = "all".equalsIgnoreCase(osArch.arch) ? oslabel : ("x86".equalsIgnoreCase(osArch.arch) ? oslabel + " 32 bits" : ("x86_64".equalsIgnoreCase(osArch.arch) ? oslabel + " 64 bits" : oslabel + " (" + osArch.arch + ")"));
        try {
            String s = StringUtils.isEmpty((CharSequence)osArch.osname) ? "/images/platform_14x14-" + osArch.osfamily + "-" + osArch.arch + ".png" : "/images/platform_14x14-" + osArch.osfamily + "_" + osArch.osname + "-" + osArch.arch + ".png";
            resource = this.getClass().getResource(s);
        }
        catch (Exception ex) {
            resource = null;
        }
        if (resource == null) {
            resource = this.getClass().getResource("/images/platform_14x14-unknow-unknow.png");
        }
        ImageIcon icon = new ImageIcon(resource);
        check.setIcon(icon);
        check.setToolTipText(tooltip);
        return check;
    }
}

