/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.warnings;

import java.util.Hashtable;
import java.util.Map;
import org.gvsig.tools.exception.BaseException;

public class NotSupportedLayerWarning
extends BaseException {
    private static final long serialVersionUID = -6929364975278666066L;
    private String layerName = null;
    private String xsLayerType = null;
    private String parentLayerName = null;
    private String xsParentLayerType = null;
    private boolean hasParent = false;

    public NotSupportedLayerWarning(String layerName, String xsLayerType, String parentLayerName, String xsParentLayerType) {
        this.layerName = layerName;
        this.xsLayerType = xsLayerType;
        this.parentLayerName = parentLayerName;
        this.xsParentLayerType = xsParentLayerType;
        this.hasParent = true;
        this.initialize();
    }

    public NotSupportedLayerWarning(String layerName, String xsLayerType) {
        this.layerName = layerName;
        this.xsLayerType = xsLayerType;
        this.hasParent = false;
        this.initialize();
    }

    private void initialize() {
        this.messageKey = "gpe_not_supported_layer_warning";
        this.formatString = this.hasParent ? "The layer '%(layerName)' with a XML schema type '%(xsLayerType)' is not contained in the parent layer '%(parentLayerName)' with a XML Schema type '%(xsParentLayerType)'" : "The layer '%(layerName)' with a XML schema type '%(xsLayerType)' is not valid in the XML Schema";
        this.code = -6929364975278666066L;
    }

    protected Map values() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("layerName", this.layerName);
        hash.put("xsLayerType", this.xsLayerType);
        if (this.hasParent) {
            hash.put("parentLayerName", this.parentLayerName);
            hash.put("xsParentLayerType", this.xsParentLayerType);
        }
        return hash;
    }
}

