/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;

public class MarkerFillProperties
extends JPanel {
    private static final long serialVersionUID = 2873569057822494979L;
    private static final double DEFAULT_SEPARATION = 20.0;
    private static final double DEFAULT_OFFSET = 10.0;
    private JNumberSpinner txtOffsetX;
    private JNumberSpinner txtOffsetY;
    private JNumberSpinner txtSeparationX;
    private JNumberSpinner txtSeparationY;
    private ArrayList<ActionListener> listeners = new ArrayList();
    private ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < MarkerFillProperties.this.listeners.size(); ++i) {
                ((ActionListener)MarkerFillProperties.this.listeners.get(i)).actionPerformed(e);
            }
        }
    };

    public MarkerFillProperties() {
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.setColumns(1);
        layout.setVgap(5);
        this.setName(Messages.getText((String)"fill_properties"));
        JPanel offsetPnl = new JPanel();
        offsetPnl.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"offset")));
        JPanel aux = new JPanel(new FlowLayout(3, 5, 5));
        aux.add(new JLabel("X:"));
        this.txtOffsetX = new JNumberSpinner(0, 10, 0, 150, 1);
        aux.add((Component)this.txtOffsetX);
        offsetPnl.add(aux);
        aux = new JPanel(new FlowLayout(3, 5, 5));
        aux.add(new JLabel("Y:"));
        this.txtOffsetY = new JNumberSpinner(0, 10, 0, 150, 1);
        aux.add((Component)this.txtOffsetY);
        offsetPnl.add(aux);
        layout.setRows(offsetPnl.getComponentCount());
        offsetPnl.setLayout(layout);
        this.add(offsetPnl);
        JPanel separationPnl = new JPanel();
        layout = new GridLayout();
        layout.setColumns(1);
        layout.setVgap(5);
        separationPnl.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"separation")));
        JPanel aux2 = new JPanel(new FlowLayout(3, 5, 5));
        aux2.add(new JLabel("X:"));
        this.txtSeparationX = new JNumberSpinner(0, 10, 0, 150, 1);
        aux2.add((Component)this.txtSeparationX);
        separationPnl.add(aux2);
        aux2 = new JPanel(new FlowLayout(3, 5, 5));
        aux2.add(new JLabel("Y:"));
        this.txtSeparationY = new JNumberSpinner(0, 10, 0, 150, 1);
        aux2.add((Component)this.txtSeparationY);
        separationPnl.add(aux2);
        layout.setRows(separationPnl.getComponentCount());
        separationPnl.setLayout(layout);
        this.add(separationPnl);
        layout = new GridLayout();
        layout.setColumns(1);
        layout.setVgap(5);
        layout.setRows(this.getComponentCount());
        this.txtOffsetX.setDouble(10.0);
        this.txtOffsetY.setDouble(10.0);
        this.txtSeparationX.setDouble(20.0);
        this.txtSeparationY.setDouble(20.0);
        this.txtOffsetX.addActionListener(this.action);
        this.txtOffsetY.addActionListener(this.action);
        this.txtSeparationX.addActionListener(this.action);
        this.txtSeparationY.addActionListener(this.action);
        this.setLayout(layout);
    }

    public void setModel(IMarkerFillPropertiesStyle fillProps) {
        if (fillProps != null) {
            this.txtOffsetX.setDouble(fillProps.getXOffset());
            this.txtOffsetY.setDouble(fillProps.getYOffset());
            this.txtSeparationX.setDouble(fillProps.getXSeparation());
            this.txtSeparationY.setDouble(fillProps.getYSeparation());
        }
    }

    public IMarkerFillPropertiesStyle getMarkerFillProperties() {
        IMarkerFillPropertiesStyle mfProps = SymbologyLocator.getSymbologyManager().createSimpleMarkerFillPropertiesStyle();
        mfProps.setXOffset(this.txtOffsetX.getDouble());
        mfProps.setYOffset(this.txtOffsetY.getDouble());
        mfProps.setXSeparation(this.txtSeparationX.getDouble());
        mfProps.setYSeparation(this.txtSeparationY.getDouble());
        return mfProps;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.txtOffsetX.setEnabled(enabled);
        this.txtOffsetY.setEnabled(enabled);
        this.txtSeparationX.setEnabled(enabled);
        this.txtSeparationY.setEnabled(enabled);
    }
}

