/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.GrammarSet;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.Statement;
import org.gvsig.expressionevaluator.UserOperator;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultGrammarSet;
import org.gvsig.expressionevaluator.impl.I18N;
import org.gvsig.expressionevaluator.impl.SQLLexicalAnalyzer;
import org.gvsig.expressionevaluator.impl.function.operator.NegOperator;
import org.gvsig.expressionevaluator.spi.AbstractLexicalAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompiler
implements Compiler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCompiler.class);
    private boolean objectAccessSupported;
    private LexicalAnalyzer lexer;
    private CodeBuilder codeBuilder;
    private final GrammarSet grammars;
    protected ExpressionEvaluatorManager manager;
    protected Map<String, String> compatibility;

    public DefaultCompiler(ExpressionEvaluatorManager manager) {
        this.manager = manager;
        this.grammars = new DefaultGrammarSet();
        this.lexer = new SQLLexicalAnalyzer();
        this.codeBuilder = new DefaultCodeBuilder(manager);
        this.objectAccessSupported = true;
    }

    public Compiler clone() throws CloneNotSupportedException {
        DefaultCompiler other = (DefaultCompiler)super.clone();
        other.lexer = this.lexer.clone();
        other.codeBuilder = this.codeBuilder.clone();
        return other;
    }

    public void setLexicalAnalyzer(LexicalAnalyzer lexer) {
        this.lexer = lexer;
    }

    public LexicalAnalyzer getLexicalAnalyzer() {
        return this.lexer;
    }

    public void setCodeBuilder(CodeBuilder codeBuilder) {
        this.codeBuilder = codeBuilder;
    }

    public CodeBuilder getCodeBuilder() {
        return this.codeBuilder;
    }

    public boolean isObjectAccessSupported() {
        return this.objectAccessSupported;
    }

    public void setObjectAccessSupported(boolean objectAccessSupported) {
        this.objectAccessSupported = objectAccessSupported;
    }

    public GrammarSet getGrammars() {
        return this.grammars;
    }

    public Code compileExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return this.getCodeBuilder().constant(null);
        }
        this.lexer.setSource(expression.trim());
        Code code = this.parse_expression();
        if (!this.lexer.isEOF()) {
            throw new ExpressionSyntaxException(this.lexer);
        }
        return code;
    }

    public Code compileExpressionQuietly(String expression) {
        try {
            return this.compileExpression(expression);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Code parse_expression() {
        return this.parse_expression(true);
    }

    public Code parse_expression(boolean allow_assignement) {
        LexicalAnalyzer.Token token;
        Code code = this.parse_relational();
        if (code != null && allow_assignement && (token = this.lexer.look()).is(new String[]{"AS"})) {
            this.lexer.next();
            token = this.lexer.look();
            if (token.getType() != 0) {
                throw new ExpressionSyntaxException(I18N.An_identifier_was_expected_and_XliteralX_was_found(token.getLiteral()), this.lexer);
            }
            token = this.lexer.next();
            code = this.codeBuilder.let(token.getLiteral(), code);
        }
        return code;
    }

    protected Code parse_user_operator(String precedence, Code op1, Supplier<Code> op2) {
        for (UserOperator operator : this.manager.getUserDefinedOperators(precedence)) {
            Code userop = operator.parse(this.lexer, this.codeBuilder, op1, op2);
            if (userop == null) continue;
            return userop;
        }
        return op1;
    }

    public Code parse_relational() {
        Code op1 = this.parse_not();
        block9: while (true) {
            LexicalAnalyzer.Token token = this.lexer.look();
            switch (token.getType()) {
                case 43: {
                    Code op2;
                    this.lexer.next();
                    LexicalAnalyzer.Token next = this.lexer.look();
                    if (next.getType() == 30) {
                        this.lexer.next();
                        Codes v = this.parse_arguments();
                        next = this.lexer.next();
                        switch (next.getType()) {
                            case 31: {
                                break;
                            }
                            case -1: {
                                throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_end_of_source_was_found(), this.lexer);
                            }
                            default: {
                                throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_XliteralX_was_found(next.getLiteral()), this.lexer);
                            }
                        }
                        op2 = this.codeBuilder.tuple(v);
                    } else {
                        op2 = this.parse_not();
                    }
                    op1 = this.codeBuilder.in(op1, op2);
                    continue block9;
                }
                case 26: {
                    this.lexer.next();
                    Code op2 = this.parse_not();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_OR_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.or(op1, op2);
                    continue block9;
                }
                case 27: {
                    this.lexer.next();
                    Code op2 = this.parse_not();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_AND_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.and(op1, op2);
                    continue block9;
                }
            }
            break;
        }
        op1 = this.parse_user_operator("relational", op1, () -> this.parse_not());
        return op1;
    }

    public Code parse_not() {
        Code op1;
        LexicalAnalyzer.Token token = this.lexer.look();
        if (token.getType() == 9) {
            this.lexer.next();
            op1 = this.parse_conditional();
            op1 = this.codeBuilder.not(op1);
        } else {
            op1 = this.parse_conditional();
        }
        return op1;
    }

    public Code parse_conditional() {
        Code op1 = this.parse_sum();
        while (true) {
            LexicalAnalyzer.Token token = this.lexer.look();
            block0 : switch (token.getType()) {
                case 16: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_LT_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.lt(op1, op2);
                    break;
                }
                case 17: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_GT_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.gt(op1, op2);
                    break;
                }
                case 18: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_LE_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.le(op1, op2);
                    break;
                }
                case 19: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_GE_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.ge(op1, op2);
                    break;
                }
                case 20: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        token = this.lexer.look();
                        String tip = null;
                        switch (token.getType()) {
                            case 17: {
                                tip = I18N.The_operator_greater_than_or_equal_is_ge();
                                break;
                            }
                            case 16: {
                                tip = I18N.The_operator_less_than_or_equal_is_ge();
                            }
                        }
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_EQ_operator(), this.lexer, tip);
                    }
                    op1 = this.codeBuilder.eq(op1, op2);
                    break;
                }
                case 21: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_NEQ_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.ne(op1, op2);
                    break;
                }
                case 25: {
                    this.lexer.next();
                    LexicalAnalyzer.Token next = this.lexer.look();
                    switch (next.getType()) {
                        case 29: {
                            this.lexer.next();
                            op1 = this.codeBuilder.is(op1, (Code)this.codeBuilder.constant(null));
                            op1 = this.codeBuilder.not(op1);
                            break block0;
                        }
                        case 9: {
                            this.lexer.next();
                            next = this.lexer.look();
                            if (next.getType() != 4) {
                                throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_IS_operator(), this.lexer);
                            }
                            this.lexer.next();
                            op1 = this.codeBuilder.is(op1, (Code)this.codeBuilder.constant(null));
                            op1 = this.codeBuilder.not(op1);
                            break block0;
                        }
                        case 4: {
                            this.lexer.next();
                            op1 = this.codeBuilder.is(op1, (Code)this.codeBuilder.constant(null));
                            break block0;
                        }
                    }
                    throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_IS_operator(), this.lexer);
                }
                case 28: {
                    this.lexer.next();
                    op1 = this.codeBuilder.is(op1, (Code)this.codeBuilder.constant(null));
                    break;
                }
                case 15: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_REGEXP_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.regexp(op1, op2);
                    break;
                }
                case 23: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_LIKE_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.like(op1, op2);
                    break;
                }
                case 24: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_ILIKE_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.ilike(op1, op2);
                    break;
                }
                case 22: {
                    this.lexer.next();
                    Code op2 = this.parse_sum();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_operand_N_of_BETWEEN_operator(1), this.lexer);
                    }
                    LexicalAnalyzer.Token next = this.lexer.next();
                    if (next.getType() != 27) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_operand_N_of_BETWEEN_operator(2), this.lexer);
                    }
                    Code op3 = this.parse_sum();
                    op1 = this.codeBuilder.between(op1, op2, op3);
                    break;
                }
                default: {
                    op1 = this.parse_user_operator("conditional", op1, () -> this.parse_sum());
                    return op1;
                }
            }
        }
    }

    public Code parse_sum() {
        Code op1 = this.parse_factor();
        block5: while (true) {
            LexicalAnalyzer.Token token = this.lexer.look();
            switch (token.getType()) {
                case 35: {
                    this.lexer.next();
                    Code op2 = this.parse_factor();
                    op1 = this.codeBuilder.concat(op1, op2);
                    continue block5;
                }
                case 10: {
                    this.lexer.next();
                    Code op2 = this.parse_factor();
                    op1 = this.codeBuilder.add(op1, op2);
                    continue block5;
                }
                case 11: {
                    this.lexer.next();
                    Code op2 = this.parse_factor();
                    op1 = this.codeBuilder.subst(op1, op2);
                    continue block5;
                }
            }
            break;
        }
        op1 = this.parse_user_operator("sum", op1, () -> this.parse_factor());
        return op1;
    }

    public Code parse_factor() {
        Code op1 = this.parse_getattr();
        block6: while (true) {
            LexicalAnalyzer.Token token = this.lexer.look();
            switch (token.getType()) {
                case 12: {
                    this.lexer.next();
                    Code op2 = this.parse_getattr();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_MULT_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.mult(op1, op2);
                    continue block6;
                }
                case 13: {
                    this.lexer.next();
                    Code op2 = this.parse_getattr();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_DIV_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.div(op1, op2);
                    continue block6;
                }
                case 14: {
                    this.lexer.next();
                    Code op2 = this.parse_getattr();
                    if (op2 == null) {
                        throw new ExpressionSyntaxException(I18N.Cant_recognize_the_second_operand_of_MOD_operator(), this.lexer);
                    }
                    op1 = this.codeBuilder.mod(op1, op2);
                    continue block6;
                }
                case 36: {
                    this.lexer.next();
                    Code codeIndex = this.parse_expression();
                    if (codeIndex == null) {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), this.lexer);
                    }
                    token = this.lexer.look();
                    if (token.getType() != 37) {
                        throw new ExpressionSyntaxException(I18N.A_XTokenX_was_expected_and_XliteralX_was_found("]", token.getLiteral()), this.lexer);
                    }
                    this.lexer.next();
                    Code code = this.codeBuilder.getitem(op1, codeIndex);
                    return code;
                }
            }
            break;
        }
        op1 = this.parse_user_operator("factor", op1, () -> this.parse_getattr());
        return op1;
    }

    public Code parse_getattr() {
        Code op1 = this.parse_colon();
        if (!this.isObjectAccessSupported()) {
            return op1;
        }
        block3: while (true) {
            LexicalAnalyzer.Token next = this.lexer.look();
            switch (next.getType()) {
                case 33: {
                    this.lexer.next();
                    next = this.lexer.look();
                    if (next.getType() != 0) {
                        throw new ExpressionSyntaxException(I18N.An_attribute_identifier_was_expected_and_XliteralX_was_found(next.getLiteral()), this.lexer);
                    }
                    String id = next.getLiteral();
                    this.lexer.next();
                    next = this.lexer.look();
                    if (next.getType() == 30) {
                        this.lexer.next();
                        Codes args = this.parse_expressions(",");
                        next = this.lexer.next();
                        if (next.getType() != 31) {
                            throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_XliteralX_was_found(next.getLiteral()), this.lexer);
                        }
                        op1 = this.codeBuilder.method(op1, id, args);
                        continue block3;
                    }
                    op1 = this.codeBuilder.getattr(op1, id);
                    continue block3;
                }
            }
            break;
        }
        return op1;
    }

    public Code parse_colon() {
        LexicalAnalyzer.Token token = this.lexer.look();
        if (token.getType() == 40) {
            this.lexer.next();
            token = this.lexer.look();
            String mode_specifier = null;
            if (token.getType() == 0) {
                switch (token.getLiteral().trim().toUpperCase()) {
                    case "IN": {
                        this.lexer.next();
                        mode_specifier = "IN";
                        break;
                    }
                    case "OUT": {
                        this.lexer.next();
                        mode_specifier = "OUT";
                        break;
                    }
                    case "INOUT": {
                        this.lexer.next();
                        mode_specifier = "INOUT";
                        break;
                    }
                    case "ID$": {
                        this.lexer.next();
                        mode_specifier = "ID$";
                    }
                }
            } else if (token.getType() == 43) {
                this.lexer.next();
                mode_specifier = "IN";
            }
            Code op = this.parse_termino();
            if (mode_specifier == null) {
                return this.codeBuilder.$HostExpression(op);
            }
            return this.codeBuilder.$HostExpression(op, mode_specifier);
        }
        return this.parse_termino();
    }

    public Code parse_termino() {
        LexicalAnalyzer.Token token = this.lexer.look();
        switch (token.getType()) {
            case 30: {
                this.lexer.next();
                Code value = this.parse_expression();
                LexicalAnalyzer.Token next = this.lexer.next();
                switch (next.getType()) {
                    case 31: {
                        break;
                    }
                    case -1: {
                        throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_end_of_source_was_found(), this.lexer);
                    }
                    default: {
                        throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_XliteralX_was_found(next.getLiteral()), this.lexer);
                    }
                }
                return value;
            }
            case 0: {
                Code code = this.parse_grammars();
                if (code != null) {
                    return code;
                }
                if (this.grammars.isReservedWord(token.getLiteral())) {
                    return null;
                }
                this.lexer.next();
                String id = token.getLiteral();
                LexicalAnalyzer.Token next = this.lexer.look();
                if (next.getType() == 30) {
                    next = this.lexer.next();
                    Codes args = this.parse_arguments();
                    next = this.lexer.next();
                    switch (next.getType()) {
                        case 31: {
                            break;
                        }
                        case -1: {
                            throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_end_of_source_was_found(), this.lexer);
                        }
                        default: {
                            throw new ExpressionSyntaxException(I18N.Closing_parenthesis_was_expected_and_XliteralX_was_found(next.getLiteral()), this.lexer);
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"DICT") && args != null && args.size() == 1 && (code = (Code)args.get(0)).code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)((Code.Callable)code).name(), (CharSequence)"DICT")) {
                        return code;
                    }
                    return this.codeBuilder.function(id, args);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"TRUE")) {
                    return this.codeBuilder.constant((Object)true);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"FALSE")) {
                    return this.codeBuilder.constant((Object)false);
                }
                return this.codeBuilder.identifier(id);
            }
            case 1: {
                this.lexer.next();
                return this.codeBuilder.constant(token.getValue());
            }
            case 2: {
                this.lexer.next();
                return this.codeBuilder.constant(token.getValue());
            }
            case 3: {
                this.lexer.next();
                return this.codeBuilder.constant(token.getValue());
            }
            case 4: {
                this.lexer.next();
                return this.codeBuilder.constant(null);
            }
            case 5: {
                this.lexer.next();
                return this.codeBuilder.constant((Object)true);
            }
            case 6: {
                this.lexer.next();
                return this.codeBuilder.constant((Object)false);
            }
            case 11: {
                this.lexer.next();
                Code code = this.parse_termino();
                if (code.code() == 0) {
                    DefaultCodeBuilder.BaseConstant c = (DefaultCodeBuilder.BaseConstant)code;
                    if (c.value() instanceof Number) {
                        c.value(NegOperator.negate((Number)c.value()));
                        return code;
                    }
                    throw new ExpressionSyntaxException(I18N.A_numeric_constant_was_expected_after_the_unary_operator_minus(), this.lexer);
                }
                return this.codeBuilder.negate(code);
            }
            case -1: {
                throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), this.lexer);
            }
        }
        return this.parse_grammars();
    }

    public Codes parse_expressions(String sep) {
        return this.parse_expressions(sep, null);
    }

    public Codes parse_expressions(String sep, String[] terminationTokens) {
        MutableCodes codes = null;
        while (true) {
            LexicalAnalyzer.Token next;
            String literal;
            Code code;
            if (terminationTokens != null) {
                LexicalAnalyzer.Token next2 = this.lexer.look();
                String literal2 = next2.getLiteral();
                if (literal2 == null) {
                    return codes;
                }
                if (StringUtils.containsAny((CharSequence)literal2, (CharSequence[])terminationTokens)) {
                    return codes;
                }
            }
            if ((code = this.parse_expression()) != null) {
                if (codes == null) {
                    codes = this.codeBuilder.args();
                }
                codes.add(code);
            }
            if ((literal = (next = this.lexer.look()).getLiteral()) == null) {
                return codes;
            }
            if (!sep.equals(literal = literal.trim())) break;
            this.lexer.next();
        }
        return codes;
    }

    private String getKeyArgument() {
        ((AbstractLexicalAnalyzer)this.lexer).save_state();
        LexicalAnalyzer.Token next = this.lexer.look();
        if (next.getType() == 0) {
            String key = next.getLiteral();
            this.lexer.next();
            next = this.lexer.next();
            if (next.is(new String[]{":", "=", "=>"})) {
                ((AbstractLexicalAnalyzer)this.lexer).drop_state();
                return key;
            }
        }
        ((AbstractLexicalAnalyzer)this.lexer).restore_state();
        return null;
    }

    public Codes parse_arguments() {
        String sep = ",";
        MutableCodes codes = null;
        HashMap<String, Code> kwargs = null;
        while (true) {
            Code code;
            String key;
            if ((key = this.getKeyArgument()) == null) {
                if (kwargs != null) {
                    throw new ExpressionSyntaxException(I18N.nonkeyword_arg_after_keyword_arg(), this.lexer);
                }
                code = this.parse_expression();
                if (code != null) {
                    if (codes == null) {
                        codes = this.codeBuilder.args();
                    }
                    codes.add(code);
                }
            } else {
                if (kwargs == null) {
                    kwargs = new HashMap<String, Code>();
                }
                code = this.parse_expression();
                kwargs.put(key, code);
            }
            LexicalAnalyzer.Token next = this.lexer.look();
            if (!next.is(new String[]{sep})) break;
            this.lexer.next();
        }
        if (kwargs != null) {
            if (codes == null) {
                codes = this.codeBuilder.args();
            }
            Code code = this.codeBuilder.dict(kwargs);
            codes.add(code);
        }
        return codes;
    }

    private Code parse_grammars() {
        Code code;
        DefaultStatementContext context = new DefaultStatementContext();
        MutableCodes args = this.codeBuilder.args();
        context.trace("compiler.parse_gramars");
        Statement stmt = this.grammars.getApplicableStatement((Statement.StatementContext)context);
        while (stmt != null) {
            code = stmt.parse((Statement.StatementContext)context);
            args.add(code);
            stmt = this.grammars.getApplicableStatement((Statement.StatementContext)context);
        }
        switch (args.size()) {
            case 0: {
                code = null;
                break;
            }
            case 1: {
                code = (Code)args.get(0);
                break;
            }
            default: {
                code = this.codeBuilder.function("BLOCK", (Codes)args);
            }
        }
        return code;
    }

    public void addCompatibility(String compatid, String value) {
        if (this.compatibility == null) {
            this.compatibility = new HashMap<String, String>();
        }
        this.compatibility.put(compatid, value);
    }

    public String getCompatibility(String compatid) {
        if (this.compatibility == null) {
            return null;
        }
        return this.compatibility.get(compatid);
    }

    class DefaultStatementContext
    implements Statement.StatementContext {
        private State state = new State();
        private final Stack<State> states = new Stack();

        public void save_state() {
            this.trace("save_state");
            ((AbstractLexicalAnalyzer)DefaultCompiler.this.lexer).save_state();
            this.states.push(this.state);
        }

        public void restore_state() {
            ((AbstractLexicalAnalyzer)DefaultCompiler.this.lexer).restore_state();
            this.state = this.states.pop();
            this.trace("restore_state");
        }

        public void drop_state() {
            ((AbstractLexicalAnalyzer)DefaultCompiler.this.lexer).drop_state();
            this.states.pop();
            this.trace("drop_state");
        }

        public Compiler getCompiler() {
            return DefaultCompiler.this;
        }

        public LexicalAnalyzer getLexicalAnalyzer() {
            return DefaultCompiler.this.lexer;
        }

        public void setCode(String id, Code code) {
            if (this.state.codes == null) {
                this.state.codes = new HashMap<String, Code>();
            }
            if (!StringUtils.isBlank((CharSequence)this.state.codeClassifier) && id.contains("#")) {
                id = StringUtils.replace((String)id, (String)"#", (String)this.state.codeClassifier, (int)1);
            }
            this.state.codes.put(id.toUpperCase(), code);
        }

        public Code getCode(String id) {
            if (this.state == null || this.state.codes == null) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                return null;
            }
            return this.state.codes.get(id.toUpperCase());
        }

        public void setOtherValues(Object otherValues) {
            this.state.otherValues = otherValues;
        }

        public void setCodeClassifier(String classifier) {
            this.state.codeClassifier = classifier;
        }

        public Object getOtherValues() {
            return this.state.otherValues;
        }

        public String getCodeClassifier() {
            return this.state.codeClassifier;
        }

        public CodeBuilder getCodeBuilder() {
            return DefaultCompiler.this.codeBuilder;
        }

        public LexicalAnalyzer.Token look_token() {
            return DefaultCompiler.this.lexer.look();
        }

        public LexicalAnalyzer.Token next_token() {
            return DefaultCompiler.this.lexer.next();
        }

        public Code parse_expression(boolean allow_assignement) {
            return DefaultCompiler.this.parse_expression(allow_assignement);
        }

        public Codes parse_expressions(String separator) {
            return DefaultCompiler.this.parse_expressions(separator);
        }

        public Codes parse_expressions(String separator, String[] terminationTokens) {
            return DefaultCompiler.this.parse_expressions(separator, terminationTokens);
        }

        public boolean isReservedWord(String s) {
            return DefaultCompiler.this.grammars.isReservedWord(s);
        }

        public void trace(String msg) {
        }

        private class State {
            public String codeClassifier;
            public Map<String, Code> codes;
            public Object otherValues;

            private State() {
            }
        }
    }
}

