/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.tools.script.Script;

public class SimpleScript
implements Script {
    private final String name;
    private String source;
    private Interpreter interpreter;
    private List<String> names;
    private final MutableSymbolTable symbolTable;

    public SimpleScript(Interpreter interpreter, String name, String source) {
        this.interpreter = interpreter;
        this.name = name;
        this.symbolTable = ExpressionEvaluatorLocator.getManager().createSymbolTable();
        this.setCode(source);
    }

    public MutableSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.source;
    }

    public String getTypeName() {
        return "COSA";
    }

    public URL getURL() {
        return null;
    }

    public void put(String name, Object value) {
        this.symbolTable.setVar(name, value);
    }

    public Object invokeFunction(String funcname, Object[] args) throws NoSuchMethodException {
        if (this.symbolTable.function(funcname) == null && !this.interpreter.hasFunction(funcname)) {
            throw new NoSuchMethodException(funcname);
        }
        try {
            return this.interpreter.call((SymbolTable)this.symbolTable, funcname, args);
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException(this.interpreter.getCurrentCode(), "Error calling funcion '" + funcname + "'.", (Throwable)ex);
        }
    }

    public final void setCode(String source) {
        this.source = source;
        this.names = null;
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Code code = manager.compile(source);
        this.interpreter.run(this.symbolTable, code);
    }

    public List<String> getNames() {
        if (this.names == null) {
            Collection vars;
            ArrayList<String> theNames = new ArrayList<String>();
            Collection funcs = this.symbolTable.localfunctions();
            if (funcs != null) {
                for (Function function : funcs) {
                    theNames.add(function.name());
                }
            }
            if ((vars = this.symbolTable.localvariables()) != null) {
                for (String var : vars) {
                    theNames.add(var);
                }
            }
            this.names = theNames;
        }
        return this.names;
    }
}

