/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.sql.Time;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.Date;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ExtractFunction
extends AbstractFunction {
    public ExtractFunction() {
        super("Date", "EXTRACT", Range.is((Comparable)Integer.valueOf(2)), "The extract function retrieves subfields such as year or hour from date/time values. source must be a value expression of type timestamp, time, or interval. (Expressions of type date are cast to timestamp and can therefore be used as well.) field is an identifier or string that selects what field to extract from the source value. The extract function returns values of type double precision. The following are valid field names:\n\ncentury (not supported)\n\n    The century\n\n    EXTRACT(CENTURY FROM TIMESTAMP '2000-12-16 12:21:13');\n    Result: 20\n    EXTRACT(CENTURY FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 21\n\n    The first century starts at 0001-01-01 00:00:00 AD, although they did not know it at the time. This definition applies to all Gregorian calendar countries. There is no century number 0, you go from -1 century to 1 century. If you disagree with this, please write your complaint to: Pope, Cathedral Saint-Peter of Roma, Vatican.\n\nday\n\n    For timestamp values, the day (of the month) field (1 - 31) ; for interval values, the number of days\n\n    EXTRACT(DAY FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 16\n\ndecade (not supported)\n\n    The year field divided by 10\n\n    EXTRACT(DECADE FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 200\n\ndow\n\n    The day of the week as Sunday (0) to Saturday (6)\n\n    EXTRACT(DOW FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 5\n\ndoy\n\n    The day of the year (1 - 365/366)\n\n    EXTRACT(DOY FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 47\n\nhour\n\n    The hour field (0 - 23)\n\n    EXTRACT(HOUR FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 20\n\nisodow\n\n    The day of the week as Monday (1) to Sunday (7)\n\n    EXTRACT(ISODOW FROM TIMESTAMP '2001-02-18 20:38:40');\n    Result: 7\n\n    This is identical to dow except for Sunday. This matches the ISO 8601 day of the week numbering.\n\nisoyear (not supported)\n\n    The ISO 8601 week-numbering year that the date falls in (not applicable to intervals)\n\n    EXTRACT(ISOYEAR FROM DATE '2006-01-01');\n    Result: 2005\n    EXTRACT(ISOYEAR FROM DATE '2006-01-02');\n    Result: 2006\n\n    Each ISO 8601 week-numbering year begins with the Monday of the week containing the 4th of January, so in early January or late December the ISO year may be different from the Gregorian year. See the week field for more information.\n\n\nmicroseconds (not supported)\n\n    The seconds field, including fractional parts, multiplied by 1 000 000; note that this includes full seconds\n\n    EXTRACT(MICROSECONDS FROM TIME '17:12:28.5');\n    Result: 28500000\n\nmillennium (not supported)\n\n    The millennium\n\n    EXTRACT(MILLENNIUM FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 3\n\n    Years in the 1900s are in the second millennium. The third millennium started January 1, 2001.\n\nmilliseconds\n\n    The seconds field, including fractional parts, multiplied by 1000. Note that this includes full seconds.\n\n    EXTRACT(MILLISECONDS FROM TIME '17:12:28.5');\n    Result: 28500\n\nminute\n\n    The minutes field (0 - 59)\n\n    EXTRACT(MINUTE FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 38\n\nmonth\n\n    For timestamp values, the number of the month within the year (1 - 12) ; for interval values, the number of months, modulo 12 (0 - 11)\n\n    EXTRACT(MONTH FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 2\n\nquarter\n\n    The quarter of the year (1 - 4) that the date is in\n\n    EXTRACT(QUARTER FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 1\n\nsecond\n\n    The seconds field, including fractional parts (0 - 59[1])\n\n    EXTRACT(SECOND FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 40\n\n    EXTRACT(SECOND FROM TIME '17:12:28.5');\n    Result: 28.5\n\nweek\n\n    The number of the ISO 8601 week-numbering week of the year. By definition, ISO weeks start on Mondays and the first week of a year contains January 4 of that year. In other words, the first Thursday of a year is in week 1 of that year.\n\n    In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-01 is part of the 53rd week of year 2004, and 2006-01-01 is part of the 52nd week of year 2005, while 2012-12-31 is part of the first week of 2013. It's recommended to use the isoyear field together with week to get consistent results.\n\n    EXTRACT(WEEK FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 7\n\nyear\n\n    The year field. Keep in mind there is no 0 AD, so subtracting BC years from AD years should be done with care.\n\n    EXTRACT(YEAR FROM TIMESTAMP '2001-02-16 20:38:40');\n    Result: 2001\n", "EXTRACT( {{time_field}} FROM time_expression)", new String[]{"field - ", "date - a string with a date"}, "OBJECT", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        String field = this.getStr(args, 0).toLowerCase();
        Date date = (Date)this.getObject(args, 1);
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            date = new Date(date.getTime());
        } else if (date instanceof Time) {
            date = new Date(date.getTime());
        } else if (date instanceof Time) {
            date = new Date(date.getTime());
        }
        LocalDateTime time = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        Number r = null;
        switch (field) {
            case "day": {
                r = time.getDayOfMonth();
                break;
            }
            case "dow": {
                r = date.getDay();
                break;
            }
            case "hour": {
                r = time.getHour();
                break;
            }
            case "isodow": {
                r = time.getDayOfWeek().getValue();
                break;
            }
            case "minute": {
                r = time.getMinute();
                break;
            }
            case "month": {
                r = time.getMonthValue();
                break;
            }
            case "second": {
                r = (double)time.getSecond() + (double)time.getNano() / 1.0E9;
                break;
            }
            case "week": {
                r = time.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
                break;
            }
            case "year": {
                r = time.getYear();
                break;
            }
            case "quarter": {
                r = time.get(IsoFields.QUARTER_OF_YEAR);
                break;
            }
            case "doy": {
                r = time.get(ChronoField.DAY_OF_YEAR);
                break;
            }
            default: {
                throw new RuntimeException("field '" + field + "' not supported.");
            }
        }
        return r;
    }
}

