/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CeilFunction
extends AbstractFunction {
    public CeilFunction() {
        super("Numeric", "CEIL", Range.is((Comparable)Integer.valueOf(1)), "Returns the smallest (closest to negative infinity) double value that is greater than or equal to the argument and is equal to a mathematical integer. Special cases:\n- If the argument value is already equal to a mathematical integer, then the result is the same as the argument.\n- If the argument is NaN or an infinity or positive zero or negative zero, then the result is the same as the argument.\n- If the argument value is less than zero but greater than -1.0, then the result is negative zero.\nNote that the value of Math.ceil(x) is exactly the value of -Math.floor(-x).", "CEIL({{a}})", new String[]{"a - a value."}, "Double", true);
        this.addAlias("CEILING");
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r = Math.ceil(this.getDouble(args, 0));
        return r;
    }
}

