/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class MD5HexFunction
extends AbstractFunction {
    public MD5HexFunction() {
        super("Programming", "MD5HEX", Range.is((Comparable)Integer.valueOf(1)), null, "CRC32({{object}})", null, null, false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object obj = this.getObject(args, 0);
        if (obj instanceof byte[]) {
            return DigestUtils.md5Hex((byte[])((byte[])obj));
        }
        if (obj instanceof CharSequence) {
            return DigestUtils.md5Hex((byte[])obj.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (obj instanceof ByteBuffer) {
            return DigestUtils.md5Hex((byte[])((ByteBuffer)obj).array());
        }
        if (obj instanceof InputStream) {
            return DigestUtils.md5Hex((InputStream)((InputStream)obj));
        }
        if (obj instanceof Serializable) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(out);){
                oos.writeObject(obj);
            }
            return DigestUtils.md5Hex((byte[])out.toByteArray());
        }
        throw new IllegalArgumentException("type not supported");
    }
}

