/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.CosineDistance;
import org.apache.commons.text.similarity.HammingDistance;
import org.apache.commons.text.similarity.JaccardDistance;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.LevenshteinDetailedDistance;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.apache.commons.text.similarity.SimilarityScore;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class DistanceFunction
extends AbstractFunction {
    private final Map<String, SimilarityScore> methods = new HashMap<String, SimilarityScore>();

    public DistanceFunction() {
        super("String", "DISTANCE", Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)));
        this.methods.put("Cosine", (SimilarityScore)new CosineDistance());
        this.methods.put("Hamming", (SimilarityScore)new HammingDistance());
        this.methods.put("Jaccard", (SimilarityScore)new JaccardDistance());
        this.methods.put("JaroWinkler", (SimilarityScore)new JaroWinklerDistance());
        this.methods.put("Levenshtein", (SimilarityScore)new LevenshteinDistance());
        this.methods.put("LevenshteinDetailed", (SimilarityScore)new LevenshteinDetailedDistance());
        this.methods.put("LongestCommonSubsequence", (SimilarityScore)new LongestCommonSubsequenceDistance());
        this.methods.put("Soundex", new SoundexDistance());
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public boolean isSQLCompatible() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object r;
        Map options;
        String s2;
        String s1;
        switch (args.length) {
            case 0: {
                return new ArrayList<String>(this.methods.keySet());
            }
            case 1: {
                return this.getMethod(this.getStr(args, 0).getClass().getSimpleName().replace("Distance", ""));
            }
            case 2: {
                s1 = this.getStr(args, 0);
                s2 = this.getStr(args, 1);
                options = new HashMap();
                break;
            }
            default: {
                s1 = this.getStr(args, 0);
                s2 = this.getStr(args, 1);
                options = (Map)this.getObject(args, 2);
            }
        }
        String methodName = Objects.toString(options.getOrDefault("method", "Levenshtein"), "Levenshtein");
        if (StringUtils.equalsIgnoreCase((CharSequence)"Soundex", (CharSequence)methodName)) {
            String mapping = (String)options.get("mapping");
            Soundex soundex = StringUtils.isBlank((CharSequence)mapping) ? new Soundex() : new Soundex(mapping);
            r = soundex.difference(s1, s2);
        } else {
            SimilarityScore method = this.getMethod(methodName);
            r = method.apply((CharSequence)s2, (CharSequence)s2);
        }
        return r;
    }

    private SimilarityScore getMethod(String name) {
        LevenshteinDistance distance = new LevenshteinDistance();
        Integer d = Integer.MAX_VALUE;
        SimilarityScore method = null;
        for (Map.Entry<String, SimilarityScore> entry : this.methods.entrySet()) {
            String currentName = entry.getKey();
            SimilarityScore currentMethod = entry.getValue();
            Integer currentDistance = distance.apply((CharSequence)name, (CharSequence)currentName);
            if (d.compareTo(currentDistance) <= 0) continue;
            d = currentDistance;
            method = currentMethod;
        }
        return method;
    }

    private static class SoundexDistance
    implements SimilarityScore<Integer> {
        private SoundexDistance() {
        }

        public Integer apply(CharSequence left, CharSequence right) {
            try {
                Soundex x = new Soundex();
                return x.difference(left.toString(), right.toString());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

