/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.typeconversion;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class DecodeFunction
extends AbstractFunction {
    public DecodeFunction() {
        super("Conversion", "DECODE", Range.is((Comparable)Integer.valueOf(2)), "Decode binary data from textual representation in string.\nSupported formats are: base64, hex.", "DECODE({{data}}, 'hex')", new String[]{"data - A string value with the data to be converted", "format - A string value indicating the format of the input data. The default value is 'hex'."}, "Byte array", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String data_s = this.getStr(args, 0);
        String type = this.getStr(args, 1);
        if ("hex".equalsIgnoreCase(type)) {
            byte[] data = Hex.decodeHex((char[])data_s.toCharArray());
            return data;
        }
        if ("base64".equalsIgnoreCase(type)) {
            byte[] data = Base64.decodeBase64((String)data_s);
            return data;
        }
        if ("escape".equalsIgnoreCase(type)) {
            // empty if block
        }
        throw new IllegalArgumentException("Unsupported format type '" + type + "'.");
    }
}

