/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.impl.service.DefaultExportAttribute;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExportAttributes
implements ExportAttributes {
    private List<ExportAttributes.ExportAttribute> exportAttributes;
    private NamesTranslator namesTranslator = NamesTranslator.createBaseTranslator();
    private FeatureType sourceFeatureType;
    static final Logger LOGGER = LoggerFactory.getLogger(DefaultExportAttributes.class);
    private boolean active = false;
    private FeatureQuery query = null;

    public void fillExportAttributes(FeatureType ftype, FeatureQuery query) {
        DefaultExportAttribute exportAttribute;
        ArrayList<ExportAttributes.ExportAttribute> attrs = new ArrayList<ExportAttributes.ExportAttribute>();
        if (ftype != null) {
            for (FeatureAttributeDescriptor fad : ftype) {
                exportAttribute = new DefaultExportAttribute(fad.getCopy(), this.getNamesTranslator(), false);
                exportAttribute.setNewType(fad.getDataType().getType());
                exportAttribute.setSize(fad.getSize());
                if (query == null || query != null && query.getGroupByColumns().isEmpty()) {
                    exportAttribute.setExported(this.isShowableDataType(fad.getDataType()));
                } else if (query.getAggregate(fad.getName()) != null || query.getGroupByColumns().contains(fad.getName())) {
                    exportAttribute.setExported(this.isShowableDataType(fad.getDataType()));
                } else {
                    exportAttribute.setExported(false);
                }
                attrs.add(exportAttribute);
            }
        }
        if (query != null && query.getExtraColumn().getColumns() != null && !query.getExtraColumn().getColumns().isEmpty()) {
            for (FeatureAttributeDescriptor fad : query.getExtraColumn().getColumns()) {
                exportAttribute = new DefaultExportAttribute(fad.getCopy(), this.getNamesTranslator(), true);
                this.getNamesTranslator().addSource(fad.getName());
                exportAttribute.setNewType(fad.getDataType().getType());
                exportAttribute.setSize(fad.getSize());
                if (this.attributeAsComputedAndGroupBy(query, fad.getName())) {
                    exportAttribute.setComputed(false);
                }
                exportAttribute.setExported(this.isShowableDataType(fad.getDataType()));
                attrs.add(exportAttribute);
            }
        }
        this.setExportAttributes(attrs);
    }

    protected boolean attributeAsComputedAndGroupBy(FeatureQuery query, String attr) {
        if (!query.hasGroupByColumns()) {
            return false;
        }
        List groupByCols = query.getGroupByColumns();
        if (groupByCols.isEmpty()) {
            return false;
        }
        return groupByCols.contains(attr);
    }

    protected boolean isShowableDataType(DataType dataType) {
        return dataType.getType() == 66 || !dataType.isContainer() && !dataType.isObject() && dataType.getType() != 33;
    }

    public void setNamesTranslator(NamesTranslator namesTranslator) {
        if (this.namesTranslator != namesTranslator) {
            this.namesTranslator = namesTranslator;
            if (this.sourceFeatureType != null) {
                this.namesTranslator.rebuild();
            }
        }
    }

    public NamesTranslator getNamesTranslator() {
        return this.namesTranslator;
    }

    public List<ExportAttributes.ExportAttribute> toList() {
        return this.exportAttributes;
    }

    public boolean isEmpty() {
        return this.exportAttributes.isEmpty();
    }

    public int size() {
        return this.exportAttributes.size();
    }

    public Iterator<ExportAttributes.ExportAttribute> iterator() {
        return this.exportAttributes.iterator();
    }

    public ExportAttributes.ExportAttribute get(int position) {
        return this.exportAttributes.get(position);
    }

    public ExportAttributes.ExportAttribute getExportAttribute(String name) {
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            if (!StringUtils.equals((CharSequence)exportAttribute.getName(), (CharSequence)name)) continue;
            return exportAttribute;
        }
        return null;
    }

    public FeatureType getTargetFeatureType() {
        EditableFeatureType targetFeatureType = DALLocator.getDataManager().createFeatureType();
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            if (!exportAttribute.isExported()) continue;
            FeatureAttributeDescriptor descriptor = exportAttribute.getDescriptor();
            EditableFeatureAttributeDescriptor targetDescriptor = DALLocator.getDataManager().createFeatureAttributeDescriptor(descriptor.getName(), descriptor.getType());
            targetDescriptor.copyFrom((DynField)descriptor);
            targetDescriptor.setName(exportAttribute.getNewName());
            if (targetDescriptor.isComputed() && !exportAttribute.isComputed()) {
                targetDescriptor.setFeatureAttributeEmulator((FeatureAttributeEmulator)null);
            }
            if (targetDescriptor.getType() != exportAttribute.getNewDataType()) {
                targetDescriptor.setDefaultValue(null);
            }
            targetDescriptor.setDataType(exportAttribute.getNewDataType());
            targetDescriptor.setSize(exportAttribute.getSize());
            targetFeatureType.addLike((FeatureAttributeDescriptor)targetDescriptor);
        }
        Tags srcTags = this.sourceFeatureType.getTags();
        if (srcTags != null && !srcTags.isEmpty()) {
            Tags targetTags = targetFeatureType.getTags();
            for (String tagName : srcTags) {
                targetTags.set(tagName, srcTags.get(tagName));
            }
        }
        return targetFeatureType.getNotEditableCopy();
    }

    public void setSourceFeatureType(FeatureType sourceFeatureType, FeatureQuery query) {
        this.query = query;
        if (!sourceFeatureType.equals(this.sourceFeatureType)) {
            this.sourceFeatureType = sourceFeatureType;
            this.getNamesTranslator().updateSourceNames((Iterable)sourceFeatureType, new Function(){

                public Object apply(Object t) {
                    FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)t;
                    return attr.getName();
                }
            });
            this.fillExportAttributes(this.sourceFeatureType, query);
        }
    }

    public boolean isQueryAttribute(FeatureAttributeDescriptor attr) {
        if (this.query == null) {
            return false;
        }
        return this.query.getExtraColumns().get(attr.getName()) != null;
    }

    public FeatureType getSourceFeatureType() {
        return this.sourceFeatureType;
    }

    public String getTargetName(String name) {
        for (int i = 0; i < this.exportAttributes.size(); ++i) {
            ExportAttributes.ExportAttribute exportAttribute = this.exportAttributes.get(i);
            if (!StringUtils.equals((CharSequence)exportAttribute.getName(), (CharSequence)name)) continue;
            String newName = exportAttribute.getNewName();
            return newName;
        }
        return null;
    }

    public String getSourceName(String name) {
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)exportAttribute.getNewName(), (CharSequence)name)) continue;
            return exportAttribute.getName();
        }
        return null;
    }

    public int getTargetType(String name) {
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            if (!StringUtils.equals((CharSequence)exportAttribute.getName(), (CharSequence)name)) continue;
            return exportAttribute.getNewDataType();
        }
        return 0;
    }

    public int getSourceType(String name) {
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            if (!StringUtils.equals((CharSequence)exportAttribute.getNewName(), (CharSequence)name)) continue;
            return exportAttribute.getDataType();
        }
        return 0;
    }

    public ExportAttributes clone() throws CloneNotSupportedException {
        DefaultExportAttributes clone = (DefaultExportAttributes)super.clone();
        clone.namesTranslator = this.namesTranslator.clone();
        ArrayList<ExportAttributes.ExportAttribute> cloneListAttribute = new ArrayList<ExportAttributes.ExportAttribute>();
        for (ExportAttributes.ExportAttribute exportAttribute : this.exportAttributes) {
            cloneListAttribute.add(exportAttribute.clone());
        }
        clone.setExportAttributes(cloneListAttribute);
        return clone;
    }

    public void setExportAttributes(List<ExportAttributes.ExportAttribute> exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ExportAttributes") == null) {
            DynStruct definition = manager.addDefinition(DefaultExportAttributes.class, "ExportAttributes", "ExportAttributes persistence definition", null, null);
            definition.addDynFieldList("exportAttributes").setClassOfItems(ExportAttributes.ExportAttribute.class);
            definition.addDynFieldObject("namesTranslator").setClassOfValue(NamesTranslator.class);
            definition.addDynFieldObject("sourceFeatureType").setClassOfValue(FeatureType.class);
            definition.addDynFieldBoolean("active");
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("exportAttributes", this.exportAttributes.iterator());
        state.set("namesTranslator", (Object)this.namesTranslator);
        state.set("sourceFeatureType", (Object)this.sourceFeatureType);
        state.set("active", this.active);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        Iterator it = state.getIterator("exportAttributes");
        ArrayList<ExportAttributes.ExportAttribute> data = new ArrayList<ExportAttributes.ExportAttribute>();
        while (it.hasNext()) {
            ExportAttributes.ExportAttribute ref = (ExportAttributes.ExportAttribute)it.next();
            data.add(ref);
        }
        this.exportAttributes = data;
        NamesTranslator nameTranslatorState = (NamesTranslator)state.get("namesTranslator");
        if (nameTranslatorState != null) {
            this.namesTranslator = nameTranslatorState;
        }
        this.sourceFeatureType = (FeatureType)state.get("sourceFeatureType");
        this.active = state.getBoolean("active");
    }
}

