/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.Sextante;
import java.io.File;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;

public class FileTools {
    public static final String[] RASTER3D_EXT_IN = new String[]{"asc3d"};
    public static final String[] RASTER_EXT_IN = new String[]{"tif", "asc", "dat", "tiff", "bmp", "gif", "img", "jpg", "png", "vrt", "lan", "gis", "pix", "aux", "adf", "mpr", "mpl", "map", "hdr"};
    public static final String[] RASTER_DRIVERS_IN = new String[]{"RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore", "RasterStore"};
    public static final String[] VECTOR_EXT_IN = new String[]{"shp", "gml", "dxf", "dgn", "dwg"};
    public static final String[] VECTOR_DRIVERS_IN = new String[]{"GML", "DXF", "DGN", "DWG"};
    public static final String[] TABLE_EXT = new String[]{"dbf"};
    public static final String[] LAYERS_EXT_IN = new String[]{"tif", "asc", "dat", "tiff", "bmp", "gif", "img", "jpg", "png", "vrt", "lan", "gis", "pix", "aux", "adf", "mpr", "mpl", "map", "shp", "gml", "dxf", "dgn", "dwg"};
    public static final String[] LAYER_DRIVERS_IN = new String[]{"Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Gdal Store", "Shape", "GML", "DXF", "DGN", "DWG"};
    public static final boolean[] LAYER_RASTER = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};

    public static FLayer openLayer(String sFilename, String sName, IProjection projection) {
        String sExtension = sFilename.substring(sFilename.lastIndexOf(46) + 1, sFilename.length());
        for (int i = 0; i < LAYERS_EXT_IN.length; ++i) {
            if (!sExtension.equals(LAYERS_EXT_IN[i])) continue;
            try {
                FLayer layer;
                DataManager dm = DALLocator.getDataManager();
                DataStoreParameters params = dm.createStoreParameters(LAYER_DRIVERS_IN[i]);
                ((FilesystemStoreParameters)params).setFile(new File(sFilename));
                if (!(params instanceof RasterDataParameters)) {
                    params.setDynValue("crs", (Object)projection);
                }
                if ((layer = MapContextLocator.getMapContextManager().createLayer(sName, params)) != null && layer.isAvailable()) {
                    return layer;
                }
                return null;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static TableDocument openTable(String sFilename, String sName) {
        DataManager dm = DALLocator.getDataManager();
        try {
            DataStoreParameters storeParameters = dm.createStoreParameters("DBF");
            storeParameters.setDynValue("dbfFile", (Object)sFilename);
            FeatureStore store = (FeatureStore)dm.openStore("DBF", storeParameters);
            TableDocument pt = (TableDocument)ProjectManager.getInstance().createDocument(TableManager.TYPENAME, sName);
            pt.setStore(store);
            return pt;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public static Object open(String sFilename) {
        IProjection projection = ((ProjectPreferences)ApplicationLocator.getManager().getPreferences("project")).getDefaultProjection();
        FLayer layer = FileTools.openLayer(sFilename, sFilename, projection);
        if (layer != null) {
            return layer;
        }
        TableDocument table = FileTools.openTable(sFilename, sFilename);
        return table;
    }
}

