/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.AbstractTable;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import java.io.File;
import java.util.Iterator;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FeatureSetIRecordsetIterator;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FileTools;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class TableDocumentITable
extends AbstractTable {
    private final int PRECISION = 5;
    private TableDocument m_Table;
    private String m_sName;
    private String m_sFilename;
    private FeatureType featureType;
    private FeatureStore featureStore;

    public String getName() {
        if (this.m_Table != null) {
            return this.m_Table.getName();
        }
        return this.m_sName;
    }

    public void create(TableDocument table) {
        try {
            this.m_Table = table;
            this.featureStore = table.getStore();
            this.featureType = this.featureStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void create(String sName, String sFilename, Class<?>[] types, String[] sFields) {
        try {
            this.m_sName = sName;
            DataManager datamanager = DALLocator.getDataManager();
            FilesystemServerExplorerParameters explorerParams = (FilesystemServerExplorerParameters)datamanager.createServerExplorerParameters("FilesystemExplorer");
            explorerParams.setRoot(new File(sFilename).getParent());
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)datamanager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            NewFeatureStoreParameters newParams = (NewFeatureStoreParameters)explorer.getAddParameters(new File(sFilename));
            EditableFeatureType editableFeatureType = newParams.getDefaultFeatureType();
            this.featureType = editableFeatureType;
            this.loadFeatureType(sFields, types, editableFeatureType);
            newParams.setDefaultFeatureType(this.featureType);
            explorer.add(newParams.getDataStoreName(), (NewDataStoreParameters)newParams, true);
            DataManager manager = DALLocator.getDataManager();
            this.featureStore = (FeatureStore)manager.openStore(newParams.getDataStoreName(), (DataStoreParameters)newParams);
            this.featureStore.edit(2);
            this.featureType = this.featureStore.getDefaultFeatureType();
            this.m_sFilename = sFilename;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void loadFeatureType(String[] fields, Class<?>[] types, EditableFeatureType featureType) {
        int[] iTypes = this.getTypes(types);
        for (int i = 0; i < fields.length; ++i) {
            featureType.add(fields[i], iTypes[i]).setPrecision(5);
        }
    }

    private int[] getTypes(Class<?>[] classes) {
        DataTypesManager typesManager = ToolsLocator.getDataTypesManager();
        int[] types = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = typesManager.getDataType(classes[i]).getType();
        }
        return types;
    }

    public void addRecord(Object[] record) {
        try {
            EditableFeature ef = this.featureStore.createNewFeature();
            Iterator features = this.featureType.iterator();
            int i = 0;
            while (features.hasNext()) {
                FeatureAttributeDescriptor featureAttributeDescriptor = (FeatureAttributeDescriptor)features.next();
                ef.set(featureAttributeDescriptor.getName(), record[i]);
                ++i;
            }
            this.featureStore.insert(ef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IRecordsetIterator iterator() {
        try {
            return new FeatureSetIRecordsetIterator(this.featureStore.getFeatureSet(this.m_Table.getQuery()));
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFieldName(int i) {
        return this.featureType.get(i).getName();
    }

    public Class<?> getFieldType(int i) {
        return this.featureType.getAttributeDescriptor(i).getDataType().getDefaultClass();
    }

    public int getFieldCount() {
        return this.featureType.size();
    }

    public long getRecordCount() {
        try {
            return this.featureStore.getFeatureSet(this.m_Table.getQuery()).getSize();
        }
        catch (DataException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void postProcess() {
        TableDocument table;
        if (this.featureStore.isAppending() || this.featureStore.isEditing()) {
            try {
                this.featureStore.finishEditing();
            }
            catch (DataException e) {
                return;
            }
        }
        try {
            table = (TableDocument)ProjectManager.getInstance().createDocument(TableManager.TYPENAME, this.m_sName);
            table.setStore(this.featureStore);
        }
        catch (Exception e) {
            return;
        }
        table = FileTools.openTable(this.m_sFilename, this.m_sName);
        this.create(table);
    }

    public void open() {
    }

    public void close() {
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void setName(String name) {
        if (this.m_Table != null) {
            this.m_Table.setName(name);
        } else {
            this.m_sName = name;
        }
    }

    public Object getBaseDataObject() {
        return this.m_Table;
    }

    public void free() {
        this.m_Table = null;
    }

    public IOutputChannel getOutputChannel() {
        return new FileOutputChannel(this.m_sFilename);
    }
}

