/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.swing.impl.linelegend;

import javax.swing.SpinnerNumberModel;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.linelegend.UrbanHorizontalSignageConfigPanel;
import org.gvsig.legend.urbanhorizontalsignage.swing.impl.linelegend.DefaultUrbanHorizontalSignageConfigPanelView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrbanHorizontalSignageConfigPanel
extends DefaultUrbanHorizontalSignageConfigPanelView
implements UrbanHorizontalSignageConfigPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUrbanHorizontalSignageConfigPanel.class);
    private AttributeDescriptorPickerController widthFieldController;
    private AttributeDescriptorPickerController continuityFieldController;
    private AttributeDescriptorPickerController segmentsColorFieldController;
    private AttributeDescriptorPickerController paintHolesFieldController;
    private AttributeDescriptorPickerController holesColorFieldController;
    private AttributeDescriptorPickerController segmentsLengthFieldController;
    private AttributeDescriptorPickerController holesLengthFieldController;
    private AttributeDescriptorPickerController roundVertexFieldController;

    public DefaultUrbanHorizontalSignageConfigPanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.widthFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboWidthFields, t -> t.getDataType().isNumeric());
        this.continuityFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboContinuityFields, t -> t.getDataType().isNumeric());
        this.segmentsColorFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboSegmentsColorFields, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.segmentsLengthFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboSegmentsLengthFields, t -> t.getDataType().isNumeric());
        this.paintHolesFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboPaintHolesFields, t -> t.getType() != 66);
        this.holesColorFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboHolesColorFields, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.holesLengthFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboHolesLengthFields, t -> t.getDataType().isNumeric());
        this.roundVertexFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboRoundVertexFields, t -> t.getType() != 66);
        SpinnerNumberModel spnModel = new SpinnerNumberModel(15, 0, Integer.MAX_VALUE, 1);
        this.spnGapWith.setModel(spnModel);
        this.translateAll();
    }

    private void translateAll() {
        ToolsSwingManager toolsSwingmanager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingmanager.translate(this.lblWidthField);
        toolsSwingmanager.translate(this.lblContinuityField);
        toolsSwingmanager.translate(this.lblSegmentsColorField);
        toolsSwingmanager.translate(this.lblSegmentsLengthField);
        toolsSwingmanager.translate(this.lblHolesColorField);
        toolsSwingmanager.translate(this.lblPaintHolesField);
        toolsSwingmanager.translate(this.lblHolesLengthField);
        toolsSwingmanager.translate(this.lblRoundVertexField);
        toolsSwingmanager.translate(this.lblGapWidth);
    }

    public void put(UrbanHorizontalSignageConfig config) {
        this.widthFieldController.set(config.getWidthFieldName());
        this.continuityFieldController.set(config.getContinuityFieldName());
        this.segmentsColorFieldController.set(config.getSegmentsColorFieldName());
        this.segmentsLengthFieldController.set(config.getSegmentsLengthFieldName());
        this.paintHolesFieldController.set(config.getPaintHolesFieldName());
        this.holesColorFieldController.set(config.getHolesColorFieldName());
        this.holesLengthFieldController.set(config.getHolesLengthFieldName());
        this.roundVertexFieldController.set(config.getRoundVertexFieldName());
        this.spnGapWith.getModel().setValue(config.getGapWidth());
    }

    public void fetch(UrbanHorizontalSignageConfig config) {
        config.setWidthFieldName(this.widthFieldController.getName());
        config.setContinuityFieldName(this.continuityFieldController.getName());
        config.setSegmentsColorFieldName(this.segmentsColorFieldController.getName());
        config.setSegmentsLengthFieldName(this.segmentsLengthFieldController.getName());
        config.setPaintHolesFieldName(this.paintHolesFieldController.getName());
        config.setHolesColorFieldName(this.holesColorFieldController.getName());
        config.setHolesLengthFieldName(this.holesLengthFieldController.getName());
        config.setRoundVertexFieldName(this.roundVertexFieldController.getName());
        config.setGapWith(((Integer)this.spnGapWith.getValue()).intValue());
    }

    public void setFeatureType(FeatureType type) {
        this.widthFieldController.setFeatureType(type);
        this.continuityFieldController.setFeatureType(type);
        this.segmentsColorFieldController.setFeatureType(type);
        this.segmentsLengthFieldController.setFeatureType(type);
        this.paintHolesFieldController.setFeatureType(type);
        this.holesColorFieldController.setFeatureType(type);
        this.holesLengthFieldController.setFeatureType(type);
        this.roundVertexFieldController.setFeatureType(type);
    }
}

