/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.additionalInfo;

import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import java.util.ArrayList;

public class AdditionalInfoVectorLayer
extends AdditionalInfoDataObject {
    public static final int SHAPE_TYPE_POINT = 0;
    public static final int SHAPE_TYPE_LINE = 1;
    public static final int SHAPE_TYPE_POLYGON = 2;
    public static final int SHAPE_TYPE_ANY = -1;
    public static final int MASK_NOTAPPLY = 0;
    public static final int MASK_SHAPE_TYPE_POINT = 1;
    public static final int MASK_SHAPE_TYPE_LINE = 2;
    public static final int MASK_SHAPE_TYPE_POLYGON = 4;
    public static final int MASK_SHAPE_TYPE_ANY = 7;
    private int m_iShapeType = -1;
    private int m_maskShapeType = 7;
    private boolean m_bIs3d = false;

    public AdditionalInfoVectorLayer(int iShapeType, boolean bIsMandatory) {
        this(iShapeType, bIsMandatory, 0);
    }

    public AdditionalInfoVectorLayer(int iShapeType, boolean bIsMandatory, int maskShapeType) {
        super(bIsMandatory);
        this.m_iShapeType = iShapeType;
        this.m_maskShapeType = maskShapeType;
    }

    public AdditionalInfoVectorLayer(boolean bIsMandatory, int maskShapeType) {
        super(bIsMandatory);
        this.m_maskShapeType = maskShapeType;
        this.m_iShapeType = maskShapeType == 1 ? 0 : (maskShapeType == 2 ? 1 : (maskShapeType == 4 ? 2 : -1));
    }

    public boolean isAvailableForShapeType(int shapeType) {
        if (this.m_maskShapeType == 0) {
            return this.m_iShapeType == -1 || this.m_iShapeType == shapeType;
        }
        if ((this.m_maskShapeType & 1) == 1 && shapeType == 0) {
            return true;
        }
        if ((this.m_maskShapeType & 2) == 2 && shapeType == 1) {
            return true;
        }
        return (this.m_maskShapeType & 4) == 4 && shapeType == 2;
    }

    public boolean getIs3d() {
        return this.m_bIs3d;
    }

    public void setIs3d(boolean is3d) {
        this.m_bIs3d = is3d;
    }

    public void setShapeType(int iShapeType) {
        this.m_iShapeType = iShapeType;
    }

    public int getShapeType() {
        return this.m_iShapeType;
    }

    public int[] getShapeTypes() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (this.isAvailableForShapeType(-1)) {
            types.add(-1);
        } else {
            if (this.isAvailableForShapeType(0)) {
                types.add(0);
            }
            if (this.isAvailableForShapeType(1)) {
                types.add(1);
            }
            if (this.isAvailableForShapeType(2)) {
                types.add(2);
            }
        }
        int[] shapeTypes = new int[types.size()];
        int i = 0;
        for (Integer integer : types) {
            shapeTypes[i++] = integer;
        }
        return shapeTypes;
    }

    @Override
    public String getTextDescription() {
        return null;
    }
}

