/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.core.SilentTaskMonitor;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputChart;
import es.unex.sextante.outputs.OutputImage;
import es.unex.sextante.outputs.OutputNumericalValue;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputText;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.RasterLayerAndBand;
import es.unex.sextante.shapesTools.ShapesTools;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jfree.chart.ChartPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoAlgorithm {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeoAlgorithm.class);
    protected ParametersSet m_Parameters;
    protected OutputObjectsSet m_OutputObjects;
    protected ITaskMonitor m_Task;
    protected AnalysisExtent m_AnalysisExtent;
    protected boolean m_bUserCanDefineAnalysisExtent = true;
    protected boolean m_bIsDeterminatedProcess = true;
    private String m_sName;
    private String m_sGroup;
    private String m_sDescription = null;
    private int i_R = Sextante.i_R_Algorithm;
    private int i_G = Sextante.i_G_Algorithm;
    private int i_B = Sextante.i_B_Algorithm;
    private int i_Alpha = Sextante.i_Alpha_Algorithm;
    private HashMap m_ProcessMetadata;
    protected boolean m_bIsAutoExtent;
    protected Object m_CRS;
    private long m_lInitTime;
    private long m_lEndTime;
    protected OutputFactory m_OutputFactory;
    private HashMap<String, String> m_OutputMap;
    protected boolean m_RecalculateForCell = true;

    public GeoAlgorithm() {
        this.m_Parameters = new ParametersSet();
        this.m_OutputObjects = new OutputObjectsSet();
        this.defineCharacteristics();
    }

    public boolean getRecalculateForCell() {
        return this.m_RecalculateForCell;
    }

    public void setRecalculateForCell(boolean recalculate) {
        this.m_RecalculateForCell = recalculate;
    }

    public abstract void defineCharacteristics();

    public boolean execute(ITaskMonitor task, OutputFactory outputFactory) throws GeoAlgorithmExecutionException {
        return this.execute(task, outputFactory, null);
    }

    public boolean execute(ITaskMonitor task, OutputFactory outputFactory, HashMap<String, String> outputMap) throws GeoAlgorithmExecutionException {
        StringBuffer sb = new StringBuffer();
        if (task == null) {
            this.m_Task = new SilentTaskMonitor();
        } else {
            this.m_Task = task;
            this.m_Task.setProgressText("");
        }
        this.m_OutputFactory = outputFactory;
        this.initInputDataObjects();
        if (!this.adjustOutputExtent()) {
            throw new WrongAnalysisExtentException();
        }
        DateFormat formatter = DateFormat.getDateTimeInstance();
        String[] cmd = this.getAlgorithmAsCommandLineSentences();
        if (cmd != null) {
            for (String element : cmd) {
                sb.append("Executing command: " + element + "\n");
            }
        }
        this.m_OutputMap = outputMap;
        this.m_lInitTime = System.currentTimeMillis();
        sb.append("Starting algorithm execution...:" + formatter.format(new Date(this.m_lInitTime)) + "\n");
        boolean bReturn = this.processAlgorithm();
        this.m_lEndTime = System.currentTimeMillis();
        sb.append("Finished algorithm execution:" + formatter.format(new Date(this.m_lEndTime)) + "\n");
        sb.append("Execution time (millisecs):" + Long.toString(this.m_lEndTime - this.m_lInitTime) + "\n");
        Sextante.addInfoToLog(sb.toString());
        this.closeInputDataObjects();
        this.createProcessMetadata();
        if (bReturn) {
            this.postProcessOutputDataObjects();
        } else {
            sb.append("Algorithm was canceled!!\n");
        }
        return bReturn;
    }

    private void createProcessMetadata() {
        this.m_ProcessMetadata = new HashMap();
        this.m_ProcessMetadata.put("PROCESS_DATE", new Date(this.m_lInitTime));
        this.m_ProcessMetadata.put("PROCESS_DURATION", new Long(this.m_lEndTime - this.m_lInitTime));
    }

    public HashMap getProcessMetadata() {
        return this.m_ProcessMetadata;
    }

    private void postProcessOutputDataObjects() throws GeoAlgorithmExecutionException {
        try {
            for (int i = 0; i < this.m_OutputObjects.getOutputObjectsCount(); ++i) {
                Output out = this.m_OutputObjects.getOutput(i);
                Object obj = out.getOutputObject();
                if (!(obj instanceof IDataObject)) continue;
                IDataObject dataObject = (IDataObject)obj;
                dataObject.postProcess();
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog(e);
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    private void closeInputDataObjects() {
        for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            try {
                Parameter param = this.m_Parameters.getParameter(i);
                Object obj = param.getParameterValueAsObject();
                if (obj instanceof ILayer) {
                    ILayer layer = (ILayer)obj;
                    layer.close();
                    continue;
                }
                if (obj instanceof ITable) {
                    ITable table = (ITable)obj;
                    table.close();
                    continue;
                }
                if (!(obj instanceof ArrayList)) continue;
                ArrayList list = (ArrayList)obj;
                for (int j = 0; j < list.size(); ++j) {
                    this.closeInputDataObject(list.get(j));
                }
                continue;
            }
            catch (Exception e) {
                Sextante.addErrorToLog(e);
            }
        }
    }

    private void closeInputDataObject(Object obj) {
        if (obj instanceof ILayer) {
            ILayer layer = (ILayer)obj;
            layer.close();
        } else if (obj instanceof ITable) {
            ITable table = (ITable)obj;
            table.close();
        } else if (obj instanceof RasterLayerAndBand) {
            RasterLayerAndBand rab = (RasterLayerAndBand)obj;
            IRasterLayer layer = rab.getRasterLayer();
            layer.close();
        }
    }

    private void initInputDataObjects() {
        for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            Parameter param = this.m_Parameters.getParameter(i);
            Object obj = param.getParameterValueAsObject();
            this.initInputDataObject(obj);
        }
        if (this.m_CRS == null) {
            this.m_CRS = this.m_OutputFactory.getDefaultCRS();
        }
    }

    private void initInputDataObject(Object obj) {
        block9: {
            block7: {
                ILayer layer;
                block8: {
                    if (!(obj instanceof ILayer)) break block7;
                    layer = (ILayer)obj;
                    layer.open();
                    if (this.m_CRS != null) break block8;
                    this.m_CRS = layer.getCRS();
                    break block9;
                }
                if (layer.getCRS() != null && layer.getCRS().equals(this.m_CRS)) break block9;
                Sextante.addWarningToLog("Distintos_CRS");
                break block9;
            }
            if (obj instanceof ITable) {
                ITable table = (ITable)obj;
                table.open();
            } else if (obj instanceof RasterLayerAndBand) {
                RasterLayerAndBand rlab = (RasterLayerAndBand)obj;
                IRasterLayer layer = rlab.getRasterLayer();
                layer.open();
                if (this.m_CRS == null) {
                    this.m_CRS = layer.getCRS();
                }
            } else if (obj instanceof ArrayList) {
                ArrayList list = (ArrayList)obj;
                for (int j = 0; j < list.size(); ++j) {
                    this.initInputDataObject(list.get(j));
                }
            }
        }
    }

    public abstract boolean processAlgorithm() throws GeoAlgorithmExecutionException;

    public boolean adjustOutputExtent() {
        boolean bRasterLayers = false;
        boolean bLayers = false;
        boolean bOK = true;
        if (!this.getUserCanDefineAnalysisExtent()) {
            this.m_bIsAutoExtent = false;
            return true;
        }
        if (this.m_bIsAutoExtent && this.m_AnalysisExtent != null) {
            return true;
        }
        if (this.m_AnalysisExtent == null) {
            this.m_bIsAutoExtent = true;
            for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
                try {
                    int j;
                    ArrayList layers;
                    IVectorLayer vectorLayer;
                    IRasterLayer rasterLayer;
                    if (this.m_Parameters.getParameter(i).getParameterTypeName().equals("Raster Layer")) {
                        rasterLayer = this.m_Parameters.getParameterValueAsRasterLayer(this.m_Parameters.getParameter(i).getParameterName());
                        if (rasterLayer == null) continue;
                        if (!bRasterLayers) {
                            bLayers = true;
                            bRasterLayers = true;
                            this.m_AnalysisExtent = new AnalysisExtent(rasterLayer);
                            continue;
                        }
                        if (!bRasterLayers) {
                            this.m_AnalysisExtent.setCellSize(rasterLayer.getLayerGridExtent().getCellSize());
                        }
                        this.m_AnalysisExtent.addExtent(rasterLayer.getLayerGridExtent());
                        continue;
                    }
                    if (this.m_Parameters.getParameter(i).getParameterTypeName().equals("Vector Layer")) {
                        vectorLayer = this.m_Parameters.getParameterValueAsVectorLayer(this.m_Parameters.getParameter(i).getParameterName());
                        if (vectorLayer == null) continue;
                        if (!bLayers) {
                            bLayers = true;
                            this.m_AnalysisExtent = new AnalysisExtent(vectorLayer);
                            continue;
                        }
                        this.m_AnalysisExtent.addExtent(vectorLayer.getFullExtent());
                        continue;
                    }
                    if (!this.m_Parameters.getParameter(i).getParameterTypeName().equals("Multiple Input")) continue;
                    AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)this.m_Parameters.getParameter(i).getParameterAdditionalInfo();
                    if (additionalInfo.getDataType() == 1) {
                        layers = this.m_Parameters.getParameterValueAsArrayList(this.m_Parameters.getParameter(i).getParameterName());
                        for (j = 0; j < layers.size(); ++j) {
                            rasterLayer = (IRasterLayer)layers.get(j);
                            if (!bLayers) {
                                bLayers = true;
                                bRasterLayers = true;
                                this.m_AnalysisExtent = new AnalysisExtent(rasterLayer);
                                continue;
                            }
                            this.m_AnalysisExtent.addExtent(rasterLayer.getLayerGridExtent());
                        }
                    }
                    if (additionalInfo.getDataType() == 7) {
                        layers = this.m_Parameters.getParameterValueAsArrayList(this.m_Parameters.getParameter(i).getParameterName());
                        for (j = 0; j < layers.size(); ++j) {
                            RasterLayerAndBand rlab = (RasterLayerAndBand)layers.get(j);
                            rasterLayer = rlab.getRasterLayer();
                            if (!bRasterLayers) {
                                bLayers = true;
                                bRasterLayers = true;
                                this.m_AnalysisExtent = new AnalysisExtent(rasterLayer);
                                continue;
                            }
                            this.m_AnalysisExtent.addExtent(rasterLayer.getLayerGridExtent());
                        }
                    }
                    if (additionalInfo.getDataType() != 5 && additionalInfo.getDataType() != 2 && additionalInfo.getDataType() != 3 && additionalInfo.getDataType() != 4) continue;
                    layers = this.m_Parameters.getParameterValueAsArrayList(this.m_Parameters.getParameter(i).getParameterName());
                    for (j = 0; j < layers.size(); ++j) {
                        vectorLayer = (IVectorLayer)layers.get(j);
                        if (!bLayers) {
                            bLayers = true;
                            this.m_AnalysisExtent = new AnalysisExtent(vectorLayer);
                            continue;
                        }
                        this.m_AnalysisExtent.addExtent(vectorLayer.getFullExtent());
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Sextante.addErrorToLog(e);
                    continue;
                }
                catch (WrongParameterTypeException e) {
                    Sextante.addErrorToLog(e);
                    continue;
                }
                catch (WrongParameterIDException e) {
                    Sextante.addErrorToLog(e);
                    continue;
                }
                catch (NullParameterValueException e) {
                    Sextante.addErrorToLog(e);
                    continue;
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog(e);
                }
            }
            if (this.m_OutputObjects.getOutputLayersCount() != 0) {
                boolean bl = bOK = bOK && bLayers;
            }
            if (this.m_OutputObjects.getRasterLayersCount() != 0) {
                bOK = bOK && bRasterLayers;
            }
        } else {
            bOK = true;
            this.m_bIsAutoExtent = false;
        }
        return bOK;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getGroup() {
        return this.m_sGroup;
    }

    public void setGroup(String sGroup) {
        this.m_sGroup = sGroup;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public int getColorR() {
        return this.i_R;
    }

    public int getColorG() {
        return this.i_G;
    }

    public int getColorB() {
        return this.i_B;
    }

    public int getColorAlpha() {
        return this.i_Alpha;
    }

    public void setDescription(String sDescription) {
        this.m_sDescription = sDescription;
    }

    public void setColorR(int red) {
        this.i_R = red;
    }

    public void setColorG(int green) {
        this.i_G = green;
    }

    public void setColorB(int blue) {
        this.i_B = blue;
    }

    public void setColorAlpha(int alpha) {
        this.i_Alpha = alpha;
    }

    public ParametersSet getParameters() {
        return this.m_Parameters;
    }

    public void setParameters(ParametersSet parameters) {
        this.m_Parameters = parameters;
    }

    public AnalysisExtent getAnalysisExtent() {
        return this.m_AnalysisExtent;
    }

    public void setAnalysisExtent(AnalysisExtent extent) {
        this.m_AnalysisExtent = extent;
    }

    protected boolean setProgress(int iStep, int iTotalNumberOfSteps) {
        this.m_Task.setProgress(iStep, iTotalNumberOfSteps);
        return !this.m_Task.isCanceled();
    }

    protected void setProgressText(String sText) {
        this.m_Task.setProgressText(sText);
    }

    public boolean requiresNonDataObjects() {
        return this.m_Parameters.requiresNonDataObjects();
    }

    public int getNumberOfParameters() {
        return this.m_Parameters.getNumberOfParameters();
    }

    public int getNumberOfRasterLayers(boolean includeMultipleInputs) {
        return this.m_Parameters.getNumberOfRasterLayers(includeMultipleInputs);
    }

    public int getNumberOfVectorLayers(boolean includeMultipleInputs) {
        return this.m_Parameters.getNumberOfVectorLayers(includeMultipleInputs);
    }

    public int getNumberOfPointVectorLayers() {
        return this.m_Parameters.getNumberOfPointVectorLayers();
    }

    public int getNumberOfLineVectorLayers() {
        return this.m_Parameters.getNumberOfLineVectorLayers();
    }

    public int getNumberOfPolygonLayers() {
        return this.m_Parameters.getNumberOfPolygonVectorLayers();
    }

    public int getNumberOfTables() {
        return this.m_Parameters.getNumberOfTables();
    }

    public int getNumberOfNoDataParameters() {
        return this.m_Parameters.getNumberOfNoDataParameters();
    }

    public int getNumberOfTableFieldsParameters() {
        return this.m_Parameters.getNumberOfTableFieldsParameters();
    }

    public int getNumberOfTableFilterParameters() {
        return this.m_Parameters.getNumberOfTableFilterParameters();
    }

    public int getNumberOfBandsParameters() {
        return this.m_Parameters.getNumberOfBandsParameters();
    }

    public boolean getUserCanDefineAnalysisExtent() {
        return this.m_bUserCanDefineAnalysisExtent;
    }

    public void setUserCanDefineAnalysisExtent(boolean bUserCanDefineAnalysisExtent) {
        this.m_bUserCanDefineAnalysisExtent = bUserCanDefineAnalysisExtent;
    }

    public void setIsDeterminatedProcess(boolean bDeterminated) {
        this.m_bIsDeterminatedProcess = bDeterminated;
    }

    public boolean isDeterminatedProcess() {
        return this.m_bIsDeterminatedProcess;
    }

    public OutputObjectsSet getOutputObjects() {
        return this.m_OutputObjects;
    }

    public void setOutputObjects(OutputObjectsSet ooSet) {
        this.m_OutputObjects = ooSet;
    }

    protected void addOutputObject(Output output) {
        this.m_OutputObjects.add(output);
    }

    protected void addOutputObject(String sName, String sDescription, IOutputChannel channel, Object obj) {
        Output out;
        if (obj instanceof IRasterLayer) {
            out = new OutputRasterLayer();
        } else if (obj instanceof IVectorLayer) {
            out = new OutputVectorLayer();
        } else if (obj instanceof ITable) {
            out = new OutputTable();
        } else if (obj instanceof String) {
            out = new OutputText();
        } else if (obj instanceof ChartPanel) {
            out = new OutputChart();
        } else {
            return;
        }
        out.setOutputChannel(channel);
        out.setDescription(sDescription);
        out.setName(sName);
        ((Output)out).setOutputObject(obj);
        this.m_OutputObjects.add(out);
    }

    protected IOutputChannel getOutputChannel(String sName) {
        try {
            Output out = this.m_OutputObjects.getOutput(sName);
            IOutputChannel channel = out.getOutputChannel();
            if (channel == null) {
                channel = new FileOutputChannel(this.m_OutputFactory.getTempFilename(out));
                out.setOutputChannel(channel);
                return channel;
            }
            if (channel instanceof FileOutputChannel) {
                String sFilename = this.getOutputFilename(out);
                if (sFilename == null) {
                    ((FileOutputChannel)channel).setFilename(this.m_OutputFactory.getTempFilename(out));
                    ((FileOutputChannel)channel).setTemporary(true);
                    return channel;
                }
                ((FileOutputChannel)channel).setFilename(sFilename);
                ((FileOutputChannel)channel).setTemporary(false);
                return channel;
            }
            return channel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getOutputFilename(Output out) {
        IOutputChannel channel = out.getOutputChannel();
        if (!(channel instanceof FileOutputChannel)) {
            return null;
        }
        String sFilename = ((FileOutputChannel)channel).getFilename();
        if (sFilename == null) {
            return null;
        }
        String[] exts = null;
        if (out instanceof OutputRasterLayer) {
            exts = this.m_OutputFactory.getRasterLayerOutputExtensions();
        } else if (out instanceof OutputVectorLayer) {
            exts = this.m_OutputFactory.getVectorLayerOutputExtensions();
        } else if (out instanceof OutputTable) {
            exts = this.m_OutputFactory.getTableOutputExtensions();
        } else if (out instanceof Output3DRasterLayer) {
            exts = this.m_OutputFactory.get3DRasterLayerOutputExtensions();
        } else {
            return null;
        }
        for (String element : exts) {
            if (!sFilename.endsWith(element)) continue;
            return sFilename;
        }
        return sFilename + "." + exts[0];
    }

    protected IVectorLayer getNewVectorLayer(String sName, String sDescription, int iShapeType, Class[] types, String[] sFields, int subtype) throws GeoAlgorithmExecutionException {
        try {
            OutputVectorLayer out = (OutputVectorLayer)this.m_OutputObjects.getOutput(sName);
            IOutputChannel channel = this.getOutputChannel(sName);
            IVectorLayer layer = this.m_OutputFactory.getNewVectorLayer(this.getLayerName(sName, sDescription), iShapeType, types, sFields, channel, this.m_CRS, subtype);
            if (layer != null) {
                this.addOutputVectorLayer(sName, sDescription, iShapeType, channel, layer, out.getInputLayerToOverwrite(), subtype);
            }
            return layer;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    protected IVectorLayer getNewVectorLayer(String sName, String sDescription, int iShapeType, Class[] types, String[] sFields) throws GeoAlgorithmExecutionException {
        return this.getNewVectorLayer(sName, sDescription, iShapeType, types, sFields, 4);
    }

    protected IVectorLayer getNewVectorLayer(String sName, String sDescription, int iShapeType, Class[] types, String[] sFields, int[] fieldSize) throws GeoAlgorithmExecutionException {
        return this.getNewVectorLayer(sName, sDescription, iShapeType, types, sFields, fieldSize, 4);
    }

    protected IVectorLayer getNewVectorLayer(String sName, String sDescription, int iShapeType, Class[] types, String[] sFields, int[] fieldSize, int subtype) throws GeoAlgorithmExecutionException {
        try {
            OutputVectorLayer out = (OutputVectorLayer)this.m_OutputObjects.getOutput(sName);
            IOutputChannel channel = this.getOutputChannel(sName);
            IVectorLayer layer = this.m_OutputFactory.getNewVectorLayer(this.getLayerName(sName, sDescription), iShapeType, types, sFields, channel, this.m_CRS, fieldSize, subtype);
            if (layer != null) {
                this.addOutputVectorLayer(sName, sDescription, iShapeType, channel, layer, out.getInputLayerToOverwrite(), subtype);
            }
            return layer;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    private String getLayerName(String sName, String sDescription) {
        if (this.m_OutputMap != null) {
            String mappedName = this.m_OutputMap.get(sName);
            if (mappedName == null) {
                return sName;
            }
            return mappedName;
        }
        return sDescription;
    }

    protected IVectorLayer getTempVectorLayer(int iShapeType, Class[] types, String[] sFields) throws UnsupportedOutputChannelException {
        String sFilename = this.m_OutputFactory.getTempVectorLayerFilename();
        FileOutputChannel channel = new FileOutputChannel(sFilename, true);
        return this.m_OutputFactory.getNewVectorLayer("", iShapeType, types, sFields, channel, this.m_CRS);
    }

    protected IRasterLayer getNewRasterLayer(String sName, String sDescription, int iDataType, int iBands) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer(this.getLayerName(sName, sDescription), iDataType, this.m_AnalysisExtent, iBands, channel, this.m_CRS);
        newLayer.setFullExtent();
        this.addOutputRasterLayer(sName, sDescription, iBands, channel, newLayer);
        return newLayer;
    }

    protected IRasterLayer getNewRasterLayer(String sName, String sDescription, int iDataType) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer(this.getLayerName(sName, sDescription), iDataType, this.m_AnalysisExtent, 1, channel, this.m_CRS);
        newLayer.setFullExtent();
        this.addOutputRasterLayer(sName, sDescription, 1, channel, newLayer);
        return newLayer;
    }

    protected IRasterLayer getNewRasterLayer(String sName, String sDescription, int iDataType, AnalysisExtent extent, int iBands) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer(this.getLayerName(sName, sDescription), iDataType, extent, iBands, channel, this.m_CRS);
        newLayer.setFullExtent();
        this.addOutputRasterLayer(sName, sDescription, iBands, channel, newLayer);
        return newLayer;
    }

    protected IRasterLayer getNewRasterLayer(String sName, String sDescription, int iDataType, AnalysisExtent extent) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer(this.getLayerName(sName, sDescription), iDataType, extent, 1, channel, this.m_CRS);
        newLayer.setFullExtent();
        this.addOutputRasterLayer(sName, sDescription, 1, channel, newLayer);
        return newLayer;
    }

    protected IRasterLayer getTempRasterLayer(int iDataType, AnalysisExtent extent, int iBands) throws UnsupportedOutputChannelException {
        String sFilename = this.m_OutputFactory.getTempRasterLayerFilename();
        FileOutputChannel channel = new FileOutputChannel(sFilename, true);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer("", iDataType, extent, iBands, channel, this.m_CRS);
        newLayer.setFullExtent();
        return newLayer;
    }

    protected IRasterLayer getTempRasterLayer(int iDataType, AnalysisExtent extent) throws UnsupportedOutputChannelException {
        String sFilename = this.m_OutputFactory.getTempRasterLayerFilename();
        FileOutputChannel channel = new FileOutputChannel(sFilename, true);
        IRasterLayer newLayer = this.m_OutputFactory.getNewRasterLayer("", iDataType, extent, 1, channel, this.m_CRS);
        newLayer.setFullExtent();
        return newLayer;
    }

    protected I3DRasterLayer getNew3DRasterLayer(String sName, String sDescription, int iDataType, AnalysisExtent extent) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        I3DRasterLayer newLayer = this.m_OutputFactory.getNew3DRasterLayer(this.getLayerName(sName, sDescription), iDataType, extent, channel, this.m_CRS);
        this.addOutput3DRasterLayer(sName, sDescription, channel, newLayer);
        return newLayer;
    }

    protected I3DRasterLayer getNew3DRasterLayer(String sName, String sDescription, int iDataType) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        I3DRasterLayer newLayer = this.m_OutputFactory.getNew3DRasterLayer(this.getLayerName(sName, sDescription), iDataType, this.m_AnalysisExtent, channel, this.m_CRS);
        this.addOutput3DRasterLayer(sName, sDescription, channel, newLayer);
        return newLayer;
    }

    protected ITable getNewTable(String sName, String sDescription, Class[] types, String[] sFields) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        ITable table = this.m_OutputFactory.getNewTable(this.getLayerName(sName, sDescription), types, sFields, channel);
        this.addOutputTable(sName, sDescription, channel, table);
        return table;
    }

    protected void addOutputRasterLayer(String sName, String sDescription, int iBands, IOutputChannel channel, IRasterLayer layer) {
        OutputRasterLayer out = new OutputRasterLayer();
        out.setName(sName);
        out.setDescription(sDescription);
        out.setOutputObject(layer);
        out.setOutputChannel(channel);
        out.setNumberOfBands(iBands);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputRasterLayer(String sName, String sDescription, int iBands) {
        this.addOutputRasterLayer(sName, sDescription, iBands, null, null);
    }

    protected void addOutputRasterLayer(String sName, String sDescription) {
        this.addOutputRasterLayer(sName, sDescription, 1, null, null);
    }

    protected void addOutput3DRasterLayer(String sName, String sDescription) {
        this.addOutput3DRasterLayer(sName, sDescription, null, null);
    }

    protected void addOutput3DRasterLayer(String sName, String sDescription, IOutputChannel channel, I3DRasterLayer layer) {
        Output3DRasterLayer out = new Output3DRasterLayer();
        out.setName(sName);
        out.setDescription(sDescription);
        out.setOutputObject(layer);
        out.setOutputChannel(channel);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputVectorLayer(String sName, String sDescription, int iType, IOutputChannel channel, IVectorLayer layer, String sInputLayerToOverwrite, int subtype) {
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(sName);
        out.setDescription(sDescription);
        out.setOutputObject(layer);
        out.setOutputChannel(channel);
        out.setShapeType(iType);
        out.setInputLayerToOverwrite(sInputLayerToOverwrite);
        out.setSubType(subtype);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputVectorLayer(String sName, String sDescription, int iType, IOutputChannel channel, IVectorLayer layer, String sInputLayerToOverwrite) {
        this.addOutputVectorLayer(sName, sDescription, iType, null, null, sInputLayerToOverwrite, 4);
    }

    protected void addOutputVectorLayer(String sName, String sDescription, int iType, String sInputLayerToOverwrite) {
        this.addOutputVectorLayer(sName, sDescription, iType, null, null, sInputLayerToOverwrite);
    }

    protected void addOutputVectorLayer(String sName, String sDescription, int iType) {
        this.addOutputVectorLayer(sName, sDescription, iType, null, null, null);
    }

    protected void addOutputVectorLayer(String sName, String sDescription) {
        this.addOutputVectorLayer(sName, sDescription, -1, null, null, null);
    }

    protected void addOutputTable(String sName, String sDescription, IOutputChannel channel, ITable table) {
        OutputTable out = new OutputTable();
        out.setName(sName);
        out.setDescription(sDescription);
        ((Output)out).setOutputObject(table);
        out.setOutputChannel(channel);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputTable(String sName, String sDescription) {
        this.addOutputTable(sName, sDescription, null, null);
    }

    protected void addOutputChart(String sName, String sDescription, ChartPanel chart) {
        OutputChart out = new OutputChart();
        out.setName(sName);
        out.setDescription(sDescription);
        ((Output)out).setOutputObject(chart);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputChart(String sName, String sDescription) {
        this.addOutputChart(sName, sDescription, null);
    }

    protected void addOutputImage(String sName, String sDescription) {
        OutputImage out = new OutputImage();
        out.setName(sName);
        out.setDescription(sDescription);
        ((Output)out).setOutputObject(null);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputText(String sName, String sDescription, String sText) {
        OutputText out = new OutputText();
        out.setName(sName);
        out.setDescription(sDescription);
        ((Output)out).setOutputObject(sText);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputNumericalValue(String sName, String sDescription) {
        OutputNumericalValue out = new OutputNumericalValue();
        out.setName(sName);
        out.setDescription(sDescription);
        ((Output)out).setOutputObject(null);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputNumericalValue(String sName, Number number) {
        OutputNumericalValue out = new OutputNumericalValue();
        out.setName(sName);
        out.setDescription(sName);
        ((Output)out).setOutputObject(number);
        this.m_OutputObjects.add(out);
    }

    protected void addOutputText(String sName, String sDescription) {
        this.addOutputText(sName, sDescription, null);
    }

    public String toString() {
        return this.m_sName;
    }

    public String getCommandLineName() {
        String sClass = this.getClass().getName();
        int iLast = sClass.lastIndexOf(".");
        String sCommandName = sClass.substring(iLast + 1, sClass.length() - "Algorithm".length());
        return sCommandName.toLowerCase();
    }

    public GeoAlgorithm getNewInstance() throws InstantiationException, IllegalAccessException {
        GeoAlgorithm alg = (GeoAlgorithm)this.getClass().newInstance();
        alg.setName(this.m_sName);
        alg.setGroup(this.m_sGroup);
        alg.setParameters(this.m_Parameters.getNewInstance());
        alg.setOutputObjects(this.m_OutputObjects.getNewInstance());
        if (this.m_bIsAutoExtent) {
            alg.setAnalysisExtent(null);
            alg.m_bIsAutoExtent = true;
        }
        return alg;
    }

    public boolean isSuitableForModelling() {
        return true;
    }

    public boolean preprocessForModeller(Object model) throws GeoAlgorithmExecutionException {
        return true;
    }

    public boolean generatesLayers() {
        return this.m_OutputObjects.hasLayers();
    }

    public boolean generatesLayersOrTables() {
        return this.m_OutputObjects.hasDataObjects();
    }

    public int getNumberOfOutputObjects() {
        return this.m_OutputObjects.getOutputDataObjectsCount();
    }

    public String getCommandLineHelp() {
        String sFirstLine = "Usage: runalg( \"" + this.getCommandLineName() + "\",\n";
        return this.getCommandLineParametersHelp(sFirstLine);
    }

    protected String getCommandLineParametersHelp(String sFirstLine) {
        int i;
        ParametersSet params = this.getParameters();
        StringBuffer sb = new StringBuffer(sFirstLine);
        sb.append(this.getfixedLengthBlankLine(sFirstLine.length()));
        for (i = 0; i < params.getNumberOfParameters(); ++i) {
            block32: {
                AdditionalInfo ai;
                Parameter param = params.getParameter(i);
                sb.append(param.getParameterName() + "[");
                if (param instanceof ParameterDataObject) {
                    try {
                        ai = (AdditionalInfoDataObject)param.getParameterAdditionalInfo();
                        if (!((AdditionalInfoDataObject)ai).getIsMandatory()) {
                            sb.append("Optional ");
                        }
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                        // empty catch block
                    }
                }
                sb.append(param.getParameterTypeName());
                if (param instanceof ParameterTableField) {
                    try {
                        ai = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                        sb.append(" from " + ((AdditionalInfoTableField)ai).getParentParameterName());
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                        // empty catch block
                    }
                }
                if (param instanceof ParameterFixedTable) {
                    try {
                        ai = (AdditionalInfoFixedTable)param.getParameterAdditionalInfo();
                        String[] sCols = ((AdditionalInfoFixedTable)ai).getCols();
                        sb.append(" (Cols:");
                        for (String element : sCols) {
                            sb.append(" | " + element);
                        }
                        sb.append(" | ). (Rows: ");
                        if (((AdditionalInfoFixedTable)ai).isNumberOfRowsFixed()) {
                            sb.append(((AdditionalInfoFixedTable)ai).getRowsCount() + ")");
                            break block32;
                        }
                        sb.append("any)");
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {}
                } else if (param instanceof ParameterMultipleInput) {
                    try {
                        ai = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                        switch (((AdditionalInfoMultipleInput)ai).getDataType()) {
                            case 7: {
                                sb.append(" - Band");
                                break;
                            }
                            case 1: {
                                sb.append(" - Raster Layer");
                                break;
                            }
                            case 5: {
                                sb.append(" - Vector Layer");
                                break;
                            }
                            case 2: {
                                sb.append(" - Points Layer");
                                break;
                            }
                            case 3: {
                                sb.append(" - Lines Layer");
                                break;
                            }
                            case 4: {
                                sb.append(" - Polygons Layer");
                                break;
                            }
                            case 6: {
                                sb.append(" - Table");
                            }
                        }
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                        // empty catch block
                    }
                }
            }
            sb.append("]");
            sb.append(",\n" + this.getfixedLengthBlankLine(sFirstLine.length()));
        }
        for (i = 0; i < this.m_OutputObjects.getOutputObjectsCount(); ++i) {
            Output out = this.m_OutputObjects.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
            sb.append(out.getName() + "[output ");
            if (out instanceof OutputRasterLayer) {
                sb.append("raster layer");
            } else if (out instanceof OutputVectorLayer) {
                sb.append("vector layer");
            } else if (out instanceof OutputTable) {
                sb.append("table");
            }
            sb.append("]");
            sb.append(",\n" + this.getfixedLengthBlankLine(sFirstLine.length()));
        }
        sb.append(");");
        return sb.toString();
    }

    private String getfixedLengthBlankLine(int iLength) {
        String sResult = "                                                                     ";
        return "                                                                     ".substring(0, iLength);
    }

    public File getHelpFile() {
        return null;
    }

    public String[] getAlgorithmAsCommandLineSentences() {
        String[] sReturn;
        String sFirstLine = "runalg(\"" + this.getCommandLineName() + "\", ";
        StringBuffer sb = new StringBuffer(sFirstLine);
        for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            Parameter param = this.m_Parameters.getParameter(i);
            sb.append(param.getCommandLineParameter() + ", ");
        }
        for (int j = 0; j < this.m_OutputObjects.getOutputObjectsCount(); ++j) {
            Output out = this.m_OutputObjects.getOutput(j);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof Output3DRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
            sb.append(out.getCommandLineParameter() + ", ");
        }
        String sAlg = sb.substring(0, sb.length() - 2) + ")";
        if (this.getUserCanDefineAnalysisExtent()) {
            sReturn = new String[2];
            if (this.m_bIsAutoExtent) {
                sReturn[0] = "autoextent(\"true\")";
            } else {
                AnalysisExtent ge = this.getAnalysisExtent();
                sReturn[0] = "extent( " + ge.toString() + ")";
            }
            sReturn[1] = sAlg;
        } else {
            sReturn = new String[]{sAlg};
        }
        return sReturn;
    }

    public boolean requiresVectorLayers() {
        return this.m_Parameters.requiresVectorLayers();
    }

    public boolean requiresIndividualVectorLayers() {
        return this.m_Parameters.getNumberOfVectorLayers() > 0;
    }

    public boolean requiresPolygonVectorLayers() {
        return this.m_Parameters.requiresPolygonVectorLayers();
    }

    public boolean requiresLineVectorLayers() {
        return this.m_Parameters.requiresLineVectorLayers();
    }

    public boolean requiresPointVectorLayers() {
        return this.m_Parameters.requiresPointVectorLayers();
    }

    public boolean requiresRasterLayers() {
        return this.m_Parameters.requiresRasterLayers();
    }

    public boolean requires3DRasterLayers() {
        return this.m_Parameters.requires3DRasterLayers();
    }

    public boolean requiresIndividualRasterLayers() {
        return this.m_Parameters.getNumberOfRasterLayers() > 0;
    }

    public boolean requiresMultipleRasterLayers() {
        return this.m_Parameters.requiresMultipleRasterLayers();
    }

    public boolean requiresMultipleVectorLayers() {
        return this.m_Parameters.requiresMultipleVectorLayers();
    }

    public boolean requiresMultipleTables() {
        return this.m_Parameters.requiresMultipleTables();
    }

    public boolean requiresMultipleRasterBands() {
        return this.m_Parameters.requiresMultipleRasterBands();
    }

    public boolean requiresTables() {
        return this.m_Parameters.requiresTables();
    }

    public boolean requiresTableFields() {
        return this.m_Parameters.requiresTableFields();
    }

    public boolean requiresPoints() {
        return this.m_Parameters.requiresPoints();
    }

    public boolean meetsRasterRequirements(Object[] objs) {
        if (objs == null) {
            return false;
        }
        if (this.requiresRasterLayers()) {
            for (Object element : objs) {
                if (!(element instanceof IRasterLayer)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean meets3DRasterRequirements(Object[] objs) {
        if (objs == null) {
            return false;
        }
        if (this.requires3DRasterLayers()) {
            for (Object element : objs) {
                if (!(element instanceof I3DRasterLayer)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean meetsVectorRequirements(Object[] objs) {
        boolean bPolygonLayers = false;
        boolean bLineLayers = false;
        boolean bPointLayers = false;
        boolean bVectorLayers = false;
        if (objs == null) {
            return false;
        }
        if (this.requiresVectorLayers()) {
            block5: for (Object element : objs) {
                if (!(element instanceof IVectorLayer)) continue;
                switch (((IVectorLayer)element).getShapeType()) {
                    case 0: {
                        bPointLayers = true;
                        bVectorLayers = true;
                        continue block5;
                    }
                    case 1: {
                        bLineLayers = true;
                        bVectorLayers = true;
                        continue block5;
                    }
                    case 2: {
                        bPolygonLayers = true;
                        bVectorLayers = true;
                    }
                }
            }
            if (this.requiresPointVectorLayers() && !bPointLayers || this.requiresLineVectorLayers() && !bLineLayers || this.requiresPolygonVectorLayers() && !bPolygonLayers) {
                return false;
            }
            return bVectorLayers;
        }
        return true;
    }

    public boolean meetsTableRequirements(Object[] objs) {
        if (objs == null) {
            return false;
        }
        if (this.requiresTables()) {
            for (Object element : objs) {
                if (!(element instanceof ITable)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean meetsDataRequirements(Object[] objs) {
        if (objs == null) {
            return false;
        }
        return this.meets3DRasterRequirements(objs) && this.meetsRasterRequirements(objs) && this.meetsVectorRequirements(objs) && this.meetsTableRequirements(objs);
    }

    public boolean hasCorrectParameterValues() {
        return this.m_Parameters.areParameterValuesCorrect();
    }

    public boolean isAutoExtent() {
        return this.m_bIsAutoExtent;
    }

    public boolean canDefineOutputExtentFromInput() {
        if (this.m_OutputObjects.get3DRasterLayersCount() != 0) {
            return this.requires3DRasterLayers();
        }
        if (this.m_OutputObjects.getRasterLayersCount() != 0) {
            return this.requiresRasterLayers() || this.requires3DRasterLayers();
        }
        if (this.m_OutputObjects.getVectorLayersCount() != 0) {
            return this.requiresRasterLayers() || this.requires3DRasterLayers() || this.requiresVectorLayers();
        }
        return true;
    }

    public boolean is3D() {
        return false;
    }

    public Object getOutputCRS() {
        return this.m_CRS;
    }

    public boolean isActive() {
        return true;
    }

    protected String checkAttrName(String name, int size, String[] attrNames) {
        return ShapesTools.checkAttrName(name, size, attrNames);
    }

    protected void initializeDefaultValues(Class<?>[] types, Object[] resultValues) {
        for (int j = 0; j < types.length; ++j) {
            if (String.class.isAssignableFrom(types[j])) {
                resultValues[j] = "";
                continue;
            }
            if (Number.class.isAssignableFrom(types[j])) {
                resultValues[j] = 0;
                continue;
            }
            if (!Boolean.class.isAssignableFrom(types[j])) continue;
            resultValues[j] = false;
        }
    }
}

