/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.IMonitorableTask;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import java.util.concurrent.Callable;

public class ProcessTask
implements IMonitorableTask,
Callable<Boolean> {
    private final boolean m_bFinished = false;
    private final GeoAlgorithm m_Algorithm;
    private final ITaskMonitor m_ProgressMonitor;
    private final OutputFactory m_OutputFactory;

    public ProcessTask(GeoAlgorithm algorithm, OutputFactory outputFactory, ITaskMonitor taskMonitor) {
        this.m_Algorithm = algorithm;
        this.m_OutputFactory = outputFactory;
        this.m_ProgressMonitor = taskMonitor;
        if (taskMonitor != null) {
            this.m_ProgressMonitor.setProgress(0);
        }
    }

    @Override
    public Boolean call() throws GeoAlgorithmExecutionException {
        boolean bReturn = this.m_Algorithm.execute(this.m_ProgressMonitor, this.m_OutputFactory);
        return new Boolean(bReturn);
    }

    @Override
    public boolean isCanceled() {
        return this.m_ProgressMonitor.isCanceled();
    }

    @Override
    public boolean isFinished() {
        return false;
    }
}

