/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.core.AlgorithmsAndResources;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.IGeoAlgorithmFilter;
import es.unex.sextante.core.SextanteLogHandler;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.gvsig.i18n.Messages;

public class Sextante {
    private static SextanteLogHandler m_Logger = new SextanteLogHandler();
    private static HashMap<String, HashMap<String, GeoAlgorithm>> m_Algorithms;
    public static int i_R_Input;
    public static int i_G_Input;
    public static int i_B_Input;
    public static int i_Alpha_Input;
    public static int i_R_Algorithm;
    public static int i_G_Algorithm;
    public static int i_B_Algorithm;
    public static int i_Alpha_Algorithm;
    public static int VERSION_MAJOR;
    public static int VERSION_MINOR;
    public static int VERSION_REVISION;
    public static String PORTABLE_R_FOLDER;
    public static String PORTABLE_R_SCRIPTS_FOLDER;
    public static String PORTABLE_GRASS_FOLDER;
    public static String PORTABLE_MSYS_FILE;
    public static String PORTABLE_SAGA_FOLDER;
    public static String PORTABLE_MODELS_FOLDER;
    public static String PORTABLE_SCRIPTS_FOLDER;

    public static void initialize() {
        AlgorithmsAndResources.addAlgorithmsAndPropertiesFromClasspath();
        m_Algorithms = new HashMap();
        Sextante.registeri18n();
        Sextante.loadLibraryAlgorithms();
    }

    public static void initialize(URL[] jars) {
        AlgorithmsAndResources.addAlgorithmsAndPropertiesFromURLs(jars);
        m_Algorithms = new HashMap();
        Sextante.registeri18n();
        Sextante.loadLibraryAlgorithms();
    }

    public static void initialize(String sFolder) {
        AlgorithmsAndResources.addAlgorithmsAndPropertiesFromFolder(sFolder);
        m_Algorithms = new HashMap();
        Sextante.registeri18n();
        Sextante.loadLibraryAlgorithms();
    }

    private static void registeri18n() {
        Messages.addResourceFamily((String)"org.gvsig.toolbox.i18n.text", (ClassLoader)Sextante.class.getClassLoader(), (String)Sextante.class.getClass().getName());
    }

    public static void addAlgorithmsFromProvider(String sName, HashMap<String, GeoAlgorithm> algs) {
        m_Algorithms.put(sName, algs);
    }

    public static void addGeoalgorithm(String sProviderGroup, Class<?> alg) {
        if (alg != null) {
            Object obj = null;
            try {
                obj = alg.newInstance();
            }
            catch (InstantiationException e) {
                Sextante.addErrorToLog(e);
            }
            catch (IllegalAccessException e) {
                Sextante.addErrorToLog(e);
            }
            if (obj != null && obj instanceof GeoAlgorithm) {
                HashMap<String, GeoAlgorithm> group = m_Algorithms.get(sProviderGroup);
                if (group == null) {
                    group = new HashMap();
                    m_Algorithms.put(sProviderGroup, group);
                }
                group.put(((GeoAlgorithm)obj).getCommandLineName(), obj);
            }
        }
    }

    public static void addGeoalgorithm(String sProviderGroup, GeoAlgorithm alg) {
        if (alg != null) {
            HashMap<String, GeoAlgorithm> group = m_Algorithms.get(sProviderGroup);
            if (group == null) {
                group = new HashMap();
                m_Algorithms.put(sProviderGroup, group);
            }
            group.put(alg.getCommandLineName(), alg);
        }
    }

    public static void addErrorToLog(Throwable e) {
        m_Logger.addError(e);
    }

    public static void addErrorToLog(String sError) {
        m_Logger.addError(sError);
    }

    public static void addWarningToLog(String sWarning) {
        m_Logger.addWarning(sWarning);
    }

    public static void addInfoToLog(String sInfo) {
        m_Logger.addInfo(sInfo);
    }

    public static SextanteLogHandler getLogger() {
        return m_Logger;
    }

    public static HashMap<String, HashMap<String, GeoAlgorithm>> getAlgorithms() {
        return m_Algorithms;
    }

    public static HashMap getAlgorithms(IGeoAlgorithmFilter filter) {
        HashMap<String, HashMap<String, GeoAlgorithm>> algs = new HashMap<String, HashMap<String, GeoAlgorithm>>();
        Set<String> set = m_Algorithms.keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            HashMap<String, GeoAlgorithm> group = m_Algorithms.get(key);
            Set<String> set2 = group.keySet();
            Iterator<String> iter2 = set2.iterator();
            while (iter2.hasNext()) {
                String key2 = iter.next();
                GeoAlgorithm alg = group.get(key2);
                if (!filter.accept(alg)) continue;
                HashMap<String, GeoAlgorithm> returnGroup = (HashMap<String, GeoAlgorithm>)algs.get(key);
                if (returnGroup == null) {
                    returnGroup = new HashMap<String, GeoAlgorithm>();
                    algs.put(key, returnGroup);
                }
                returnGroup.put(key2, alg);
            }
        }
        return algs;
    }

    public static GeoAlgorithm getAlgorithmFromCommandLineName(String sName) {
        Set<String> set = m_Algorithms.keySet();
        for (String key : set) {
            GeoAlgorithm alg = m_Algorithms.get(key).get(sName);
            if (alg == null) continue;
            return alg;
        }
        return null;
    }

    public static String getAlgorithmProviderName(GeoAlgorithm alg) {
        Set<String> set = m_Algorithms.keySet();
        for (String key : set) {
            String sName;
            HashMap<String, GeoAlgorithm> algs = m_Algorithms.get(key);
            if (!algs.containsKey(sName = alg.getCommandLineName())) continue;
            return key;
        }
        return "SEXTANTE";
    }

    private static void loadLibraryAlgorithms() {
        String[] algs;
        HashMap<String, GeoAlgorithm> algsMap = new HashMap<String, GeoAlgorithm>();
        for (String element : algs = AlgorithmsAndResources.getAlgorithmClassNames()) {
            try {
                GeoAlgorithm alg;
                Class<?> clazz = Class.forName(element);
                Object obj = clazz.newInstance();
                if (!(obj instanceof GeoAlgorithm) || (alg = (GeoAlgorithm)obj).getGroup() == null) continue;
                algsMap.put(alg.getCommandLineName(), alg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (algsMap.size() > 0) {
            m_Algorithms.put("SEXTANTE", algsMap);
        }
    }

    public static String getText(String sKey) {
        return Messages.getText((String)sKey);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMacOSX() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static int getAlgorithmsCount() {
        int iCount = 0;
        Set<String> set = m_Algorithms.keySet();
        for (String key : set) {
            iCount += m_Algorithms.get(key).size();
        }
        return iCount;
    }

    public static String getVersionNumber() {
        return VERSION_MAJOR + "." + VERSION_MINOR + "." + VERSION_REVISION;
    }

    static {
        i_R_Input = 255;
        i_G_Input = 255;
        i_B_Input = 255;
        i_Alpha_Input = 255;
        i_R_Algorithm = 128;
        i_G_Algorithm = 128;
        i_B_Algorithm = 128;
        i_Alpha_Algorithm = 255;
        VERSION_MAJOR = 1;
        VERSION_MINOR = 0;
        VERSION_REVISION = 0;
        PORTABLE_R_FOLDER = "r";
        PORTABLE_R_SCRIPTS_FOLDER = "r_scripts";
        PORTABLE_GRASS_FOLDER = "grass";
        PORTABLE_MSYS_FILE = "msys" + File.separator + "bin" + File.separator + "sh.exe";
        PORTABLE_SAGA_FOLDER = "saga";
        PORTABLE_MODELS_FOLDER = "models";
        PORTABLE_SCRIPTS_FOLDER = "scripts";
    }
}

