/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.core.LogElement;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SextanteLogHandler {
    private static final Logger m_Logger = LoggerFactory.getLogger(SextanteLogHandler.class);
    ArrayList<LogElement> logElements = new ArrayList();

    public void addError(String sMessage) {
        m_Logger.warn(sMessage);
        Date todaysDate = new Date();
        LogElement le = new LogElement(todaysDate, sMessage, "ERROR");
        this.logElements.add(le);
    }

    public void addError(Throwable e) {
        m_Logger.warn("", e);
        StringBuffer sb = new StringBuffer(e.toString());
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat " + trace[i] + "\n");
        }
        Throwable ourCause = e.getCause();
        sb.append("Caused by: " + this);
        if (ourCause != null) {
            trace = ourCause.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                sb.append("\tat " + trace[i] + "\n");
            }
        }
        Date todaysDate = new Date();
        LogElement le = new LogElement(todaysDate, sb.toString(), e.toString(), "ERROR");
        this.logElements.add(le);
    }

    public void addWarning(String sMessage) {
        m_Logger.warn(sMessage);
        Date todaysDate = new Date();
        LogElement le = new LogElement(todaysDate, sMessage, "WARNING");
        this.logElements.add(le);
    }

    public void addInfo(String sMessage) {
        m_Logger.info(sMessage);
        Date todaysDate = new Date();
        LogElement le = new LogElement(todaysDate, sMessage, "INFO");
        this.logElements.add(le);
    }

    public void close() throws SecurityException {
    }

    public ArrayList<LogElement> getLogElements() {
        return this.logElements;
    }

    public void clear() {
        this.logElements.clear();
    }

    public void addToLog(String sMessage, String sType, String sShortMessage) {
        Date todaysDate = new Date();
        LogElement le = new LogElement(todaysDate, sMessage, sShortMessage, sType);
        this.logElements.add(le);
        m_Logger.info(le.getAsText());
    }
}

