/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterFilepath
extends Parameter {
    private static final String OPENDIALOG = "isopendialog";
    private static final String FOLDER = "folder";
    private static final String EXTENSION = "extension";
    private static final String VOXEL = "voxel";

    @Override
    public String getParameterTypeName() {
        return "Filepath";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (String)this.m_ParameterValue;
        }
        throw new NullParameterValueException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoFilepath) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof String) {
            this.m_ParameterValue = value;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return String.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        AdditionalInfoFilepath aifp = (AdditionalInfoFilepath)this.m_ParameterAdditionalInfo;
        if (aifp != null) {
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            serializer.attribute(null, "name", FOLDER);
            serializer.attribute(null, "value", Boolean.valueOf(aifp.isFolder()).toString());
            serializer.endTag(null, "attribute");
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            serializer.attribute(null, "name", OPENDIALOG);
            serializer.attribute(null, "value", new Boolean(aifp.isOpenDialog()).toString());
            serializer.endTag(null, "attribute");
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            serializer.attribute(null, "name", VOXEL);
            serializer.attribute(null, "value", new Boolean(aifp.getIsVoxelData()).toString());
            serializer.endTag(null, "attribute");
            StringBuffer exts = new StringBuffer();
            String[] sExts = aifp.getExtensions();
            if (sExts != null && sExts.length > 0) {
                serializer.text("\n");
                serializer.text("\t\t\t");
                serializer.startTag(null, "attribute");
                serializer.attribute(null, "name", EXTENSION);
                for (int i = 0; i < sExts.length; ++i) {
                    exts.append(sExts[i]);
                    if (i >= sExts.length - 1) continue;
                    exts.append(",");
                }
                serializer.attribute(null, "value", exts.toString());
                serializer.endTag(null, "attribute");
            }
        } else {
            throw new NullParameterAdditionalInfoException();
        }
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean bFolder = false;
        boolean bOpenDialog = false;
        boolean bIsVoxel = false;
        String[] sExt = null;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(EXTENSION) == 0) {
                        sExt = parser.getAttributeValue("", "value").split(",");
                        break;
                    }
                    if (sName.compareTo(FOLDER) == 0) {
                        bFolder = parser.getAttributeValue("", "value").equals("true");
                        break;
                    }
                    if (sName.compareTo(OPENDIALOG) == 0) {
                        bOpenDialog = parser.getAttributeValue("", "value").equals("true");
                        break;
                    }
                    if (sName.compareTo(VOXEL) != 0) break;
                    bIsVoxel = parser.getAttributeValue("", "value").equals("true");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterFilepath param = new ParameterFilepath();
        AdditionalInfoFilepath ai = new AdditionalInfoFilepath(bFolder, bOpenDialog, bIsVoxel, sExt);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        String s = (String)this.m_ParameterValue;
        return "\"" + s + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        return true;
    }
}

