/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterFixedTable
extends Parameter {
    private static final String ROWS = "rows";
    private static final String FIXED = "fixed";
    private static final String COL_NAMES = "col_names";

    @Override
    public String getParameterTypeName() {
        return "Fixed Table";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoFixedTable) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof FixedTableModel) {
            this.m_ParameterValue = value;
            return true;
        }
        if (value instanceof String) {
            int i;
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)this.m_ParameterAdditionalInfo;
            int iCols = ai.getColsCount();
            String string = (String)value;
            String[] tokens = string.split(",");
            boolean bFixed = ai.isNumberOfRowsFixed();
            int iRows = tokens.length / iCols;
            if (tokens.length % iCols != 0) {
                return false;
            }
            if (bFixed && tokens.length != iCols * iRows) {
                return false;
            }
            ArrayList[] list = new ArrayList[iCols];
            for (i = 0; i < list.length; ++i) {
                list[i] = new ArrayList();
            }
            for (i = 0; i < iRows; ++i) {
                for (int j = 0; j < iCols; ++j) {
                    list[j].add(new Double(tokens[j + i * iCols].trim()));
                }
            }
            FixedTableModel ftm = new FixedTableModel(ai.getCols(), iRows, bFixed);
            ftm.setData(list);
            this.m_ParameterValue = ftm;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return FixedTableModel.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        String s;
        AdditionalInfoFixedTable aift = (AdditionalInfoFixedTable)this.m_ParameterAdditionalInfo;
        if (aift != null) {
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            serializer.attribute(null, "name", ROWS);
            serializer.attribute(null, "value", new Integer(aift.getRowsCount()).toString());
            serializer.endTag(null, "attribute");
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            serializer.attribute(null, "name", FIXED);
            serializer.attribute(null, "value", Boolean.valueOf(aift.isNumberOfRowsFixed()).toString());
            serializer.endTag(null, "attribute");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            String[] sFields = aift.getCols();
            s = sFields[0];
            for (int i = 1; i < sFields.length; ++i) {
                s = s + ";" + sFields[i];
            }
        } else {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.attribute(null, "name", COL_NAMES);
        serializer.attribute(null, "value", s);
        serializer.text("\n");
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean bFixed = false;
        int iRows = 0;
        String sColNames = null;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(ROWS) == 0) {
                        iRows = Integer.parseInt(parser.getAttributeValue("", "value"));
                    }
                    if (sName.compareTo(FIXED) == 0) {
                        bFixed = parser.getAttributeValue("", "value").equals("true");
                    }
                    if (sName.compareTo(COL_NAMES) != 0) break;
                    sColNames = parser.getAttributeValue("", "value");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterFixedTable param = new ParameterFixedTable();
        AdditionalInfoFixedTable ai = new AdditionalInfoFixedTable(sColNames.split("\\;"), iRows, bFixed);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        FixedTableModel model = (FixedTableModel)this.m_ParameterValue;
        StringBuffer sb = new StringBuffer("\"");
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                sb.append(model.getValueAt(i, j) + ",");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public boolean isParameterValueCorrect() {
        return this.m_ParameterValue != null;
    }
}

