/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.AbstractFocusedPainter;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.border.FocusedBorder;
import ch.randelshofer.quaqua.border.ImageBevelBorder;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.CachedPainter;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class QuaquaNativeTextFieldBorder
extends VisualMarginBorder
implements Border,
BackgroundBorder {
    private Insets imageInsets;
    private Border bgBorder;
    private static final int ARG_TEXT_FIELD = 2;
    private static final int ARG_SMALL_SIZE = 32;

    public QuaquaNativeTextFieldBorder() {
        this(new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), true);
    }

    public QuaquaNativeTextFieldBorder(Insets imageInsets, Insets borderInsets, boolean fill) {
        super(new Insets(0, 0, 0, 0));
        this.imageInsets = imageInsets;
    }

    private boolean isSearchField(JComponent b) {
        Object variant = b.getClientProperty("Quaqua.TextField.style");
        if (variant == null) {
            variant = b.getClientProperty("JTextField.variant");
        }
        return variant != null && variant.equals("search");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    @Override
    public Border getBackgroundBorder() {
        if (this.bgBorder == null) {
            this.bgBorder = new BGBorder();
        }
        return this.bgBorder;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets margin;
        Insets bm;
        Insets vm = this.getVisualMargin(c);
        if (this.isSearchField((JComponent)c)) {
            bm = UIManager.getInsets("TextField.searchBorderInsets");
        } else {
            switch (QuaquaUtilities.getSizeVariant(c)) {
                default: {
                    bm = UIManager.getInsets("TextField.borderInsets");
                    break;
                }
                case SMALL: {
                    bm = UIManager.getInsets("TextField.smallBorderInsets");
                    break;
                }
                case MINI: {
                    bm = UIManager.getInsets("TextField.miniBorderInsets");
                }
            }
        }
        if (bm != null) {
            InsetsUtil.setTo(bm, insets);
        } else {
            InsetsUtil.clear(insets);
        }
        if (vm != null) {
            InsetsUtil.addTo(vm, insets);
        }
        if (c instanceof JTextComponent && (margin = ((JTextComponent)c).getMargin()) != null) {
            InsetsUtil.addTo(margin, insets);
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static class UIResource
    extends QuaquaNativeTextFieldBorder
    implements javax.swing.plaf.UIResource {
        public UIResource() {
        }

        public UIResource(Insets imageInsets, Insets borderInsets, boolean fill) {
            super(imageInsets, borderInsets, fill);
        }
    }

    private class BGSearchFieldBorder
    extends CachedPainter
    implements Border {
        private OSXAquaPainter painter;
        private ImageBevelBorder imageBevelBorder;

        public BGSearchFieldBorder() {
            super(12);
            this.painter = new OSXAquaPainter();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            OSXAquaPainter.Size size;
            OSXAquaPainter.Widget widget;
            OSXAquaPainter.State state;
            JTextComponent b = (JTextComponent)c;
            boolean isEditable = b.isEditable();
            int args = 0;
            if (QuaquaUtilities.isOnActiveWindow(c)) {
                state = OSXAquaPainter.State.active;
                args |= 1;
            } else {
                state = OSXAquaPainter.State.inactive;
            }
            if (QuaquaNativeTextFieldBorder.this.isSearchField(b)) {
                widget = OSXAquaPainter.Widget.frameTextFieldRound;
            } else {
                args |= 2;
                widget = OSXAquaPainter.Widget.frameTextField;
            }
            this.painter.setWidget(widget);
            if (!b.isEnabled() || !isEditable) {
                state = OSXAquaPainter.State.disabled;
                args |= 4;
            }
            this.painter.setState(state);
            boolean isFocusedAndEditable = QuaquaUtilities.isFocused(c) && isEditable;
            args |= isFocusedAndEditable ? 16 : 0;
            this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocusedAndEditable ? 1.0 : 0.0);
            switch (QuaquaUtilities.getSizeVariant(c)) {
                default: {
                    size = OSXAquaPainter.Size.regular;
                    break;
                }
                case SMALL: {
                    size = OSXAquaPainter.Size.small;
                    args |= 0x20;
                    break;
                }
                case MINI: {
                    size = OSXAquaPainter.Size.small;
                    args |= 0x20;
                }
            }
            this.painter.setSize(size);
            this.paint(c, g, x, y, width, height, args);
        }

        @Override
        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            return new BufferedImage(w, h, 3);
        }

        @Override
        protected void paintToImage(Component c, Image img, int w, int h, Object argsObj) {
            int args = (Integer)argsObj;
            Insets vm = QuaquaNativeTextFieldBorder.this.getVisualMargin(c);
            if ((args & 2) == 2) {
                BufferedImage ibbImg;
                int fixedYOffset;
                int fixedHeight;
                boolean isShow = false;
                if ((args & 0x20) == 32) {
                    fixedHeight = 19;
                    fixedYOffset = 3;
                } else {
                    fixedHeight = 22;
                    fixedYOffset = 3;
                }
                if (this.imageBevelBorder == null) {
                    ibbImg = new BufferedImage(40, fixedHeight, 3);
                    this.imageBevelBorder = new ImageBevelBorder(ibbImg, new Insets(4, 4, 4, 4), new Insets(0, 0, 0, 0));
                } else {
                    ibbImg = (BufferedImage)this.imageBevelBorder.getImage();
                    if (ibbImg.getHeight() != fixedHeight) {
                        ibbImg = new BufferedImage(40, fixedHeight, 3);
                        this.imageBevelBorder.setImage(ibbImg);
                    }
                }
                Graphics2D ibbg = (Graphics2D)ibbImg.getGraphics();
                ibbg.setColor(new Color(0, true));
                ibbg.setComposite(AlphaComposite.getInstance(2));
                ibbg.fillRect(0, 0, ibbImg.getWidth(), ibbImg.getHeight());
                ibbg.setComposite(AlphaComposite.getInstance(3));
                ibbg.dispose();
                this.painter.paint(ibbImg, 0.0, fixedYOffset, ibbImg.getWidth(), ibbImg.getHeight());
                Graphics2D ig = (Graphics2D)img.getGraphics();
                ig.setColor(new Color(0, true));
                ig.setComposite(AlphaComposite.getInstance(2));
                ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
                ig.setComposite(AlphaComposite.getInstance(3));
                this.imageBevelBorder.paintBorder(c, ig, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left - 3 + vm.left, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top - 3 + vm.top, w - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.right + 6 - vm.left - vm.right, h - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.bottom + 6 - vm.top - vm.bottom);
                ig.dispose();
            } else {
                Graphics2D ig = (Graphics2D)img.getGraphics();
                ig.setColor(new Color(0, true));
                ig.setComposite(AlphaComposite.getInstance(2));
                ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
                ig.setComposite(AlphaComposite.getInstance(3));
                ig.dispose();
                this.painter.paint((BufferedImage)img, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left + vm.left, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top + vm.top, w - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.right - vm.left - vm.right, h - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.bottom - vm.top - vm.bottom);
            }
        }

        @Override
        protected void paintToImage(Component c, Graphics g, int w, int h, Object args) {
            BufferedImage img = (BufferedImage)this.createImage(c, (w / 32 + 1) * 32, (h / 32 + 1) * 32, null);
            this.paintToImage(c, img, w, h, args);
            g.drawImage(img, 0, 0, null);
            img.flush();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class BGTextFieldBorder
    implements Border {
        private BufferedImage regularPainterImage;
        private BufferedImage smallPainterImage;
        private BufferedImage regularFocusImage;
        private BufferedImage smallFocusImage;
        private ImageBevelBorder regularIbb;
        private ImageBevelBorder smallIbb;
        private OSXAquaPainter painter = new OSXAquaPainter();

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ImageBevelBorder ibb;
            BufferedImage focusImg;
            BufferedImage painterImg;
            int fixedYOffset;
            OSXAquaPainter.Size size;
            OSXAquaPainter.Widget widget;
            OSXAquaPainter.State state;
            int args = 0;
            JTextComponent b = (JTextComponent)c;
            boolean isEditable = b.isEditable();
            if (QuaquaUtilities.isOnActiveWindow(c)) {
                state = OSXAquaPainter.State.active;
                args |= 1;
            } else {
                state = OSXAquaPainter.State.inactive;
            }
            if (QuaquaNativeTextFieldBorder.this.isSearchField(b)) {
                widget = OSXAquaPainter.Widget.frameTextFieldRound;
            } else {
                args |= 2;
                widget = OSXAquaPainter.Widget.frameTextField;
            }
            this.painter.setWidget(widget);
            if (!b.isEnabled() || !isEditable) {
                state = OSXAquaPainter.State.disabled;
                args |= 4;
            }
            this.painter.setState(state);
            boolean isFocusedAndEditable = QuaquaUtilities.isFocused(c) && isEditable;
            args |= isFocusedAndEditable ? 16 : 0;
            this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocusedAndEditable ? 1.0 : 0.0);
            switch (QuaquaUtilities.getSizeVariant(c)) {
                default: {
                    size = OSXAquaPainter.Size.regular;
                    break;
                }
                case SMALL: {
                    size = OSXAquaPainter.Size.small;
                    args |= 0x20;
                    break;
                }
                case MINI: {
                    size = OSXAquaPainter.Size.small;
                    args |= 0x20;
                }
            }
            this.painter.setSize(size);
            Insets vm = QuaquaNativeTextFieldBorder.this.getVisualMargin(c);
            int slack = 6;
            if ((args & 0x20) == 32) {
                int fixedWidth = 40 + slack * 2;
                int fixedHeight = 19 + slack * 2;
                fixedYOffset = 3;
                if (this.smallPainterImage == null) {
                    this.smallPainterImage = new BufferedImage(fixedWidth, fixedHeight, 3);
                }
                painterImg = this.smallPainterImage;
                if (this.smallFocusImage == null) {
                    this.smallFocusImage = new BufferedImage(fixedWidth, fixedHeight, 3);
                }
                focusImg = this.smallFocusImage;
                if (this.smallIbb == null) {
                    BufferedImage ibbImg = new BufferedImage(fixedWidth, fixedHeight, 3);
                    ibb = this.smallIbb = new ImageBevelBorder(ibbImg, new Insets(4 + slack, 4 + slack, 4 + slack, 4 + slack), new Insets(4 + slack, 4 + slack, 4 + slack, 4 + slack));
                } else {
                    ibb = this.smallIbb;
                }
            } else {
                int fixedWidth = 40 + slack * 2;
                int fixedHeight = 22 + slack * 2;
                fixedYOffset = 3;
                if (this.regularPainterImage == null) {
                    this.regularPainterImage = new BufferedImage(fixedWidth, fixedHeight, 3);
                }
                painterImg = this.regularPainterImage;
                if (this.regularFocusImage == null) {
                    this.regularFocusImage = new BufferedImage(fixedWidth, fixedHeight, 3);
                }
                focusImg = this.regularFocusImage;
                if (this.regularIbb == null) {
                    BufferedImage ibbImg = new BufferedImage(fixedWidth, fixedHeight, 3);
                    ibb = this.regularIbb = new ImageBevelBorder(ibbImg, new Insets(8 + slack, 8 + slack, 8 + slack, 8 + slack), new Insets(8 + slack, 8 + slack, 8 + slack, 8 + slack));
                } else {
                    ibb = this.regularIbb;
                }
            }
            BufferedImage ibbImg = (BufferedImage)ibb.getImage();
            Graphics2D pg = painterImg.createGraphics();
            pg.setColor(new Color(0, true));
            pg.setComposite(AlphaComposite.getInstance(2));
            pg.fillRect(0, 0, painterImg.getWidth(), painterImg.getHeight());
            pg.setComposite(AlphaComposite.getInstance(3));
            pg.dispose();
            this.painter.paint(painterImg, slack, fixedYOffset + slack, painterImg.getWidth() - 2 * slack, painterImg.getHeight() - 2 * slack);
            Graphics2D ibbg = ibbImg.createGraphics();
            ibbg.setColor(new Color(0, true));
            ibbg.setComposite(AlphaComposite.getInstance(2));
            ibbg.fillRect(0, 0, painterImg.getWidth(), painterImg.getHeight());
            ibbg.setComposite(AlphaComposite.getInstance(3));
            ibbg.drawImage((Image)painterImg, 0, 0, null);
            if (QuaquaUtilities.isFocused(c) && isEditable) {
                AbstractFocusedPainter.paintFocusRing(painterImg, focusImg, ibbg, 0, 0);
            }
            ibbg.dispose();
            ibb.paintBorder(c, g, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left - slack + vm.left, ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top - slack + vm.top, width - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.left - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.right + 2 * slack - vm.left - vm.right, height - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.top - ((QuaquaNativeTextFieldBorder)QuaquaNativeTextFieldBorder.this).imageInsets.bottom + 2 * slack - vm.top - vm.bottom);
            ibbg.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class BGBorder
    implements Border {
        private Border searchFieldBorder;
        private Border textFieldBorder;

        private BGBorder() {
        }

        private Border getActualBorder(Component c) {
            if (c instanceof JComponent && QuaquaNativeTextFieldBorder.this.isSearchField((JComponent)c)) {
                if (this.searchFieldBorder == null) {
                    this.searchFieldBorder = new FocusedBorder(new BGSearchFieldBorder());
                }
                return this.searchFieldBorder;
            }
            if (this.textFieldBorder == null) {
                this.textFieldBorder = new BGTextFieldBorder();
            }
            return this.textFieldBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.getActualBorder(c).paintBorder(c, g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getActualBorder(c).getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

