/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashSet;
import javax.swing.border.Border;

public class AnimatedBorder
implements Border {
    private HashSet scheduledComponents = new HashSet();
    private Border[] borders;
    private long delay;

    public AnimatedBorder(Border[] borders, long delay) {
        this.borders = borders;
        this.delay = delay;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.borders[0].getBorderInsets(c).clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return this.borders[0].isBorderOpaque();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        long animTime = System.currentTimeMillis() % ((long)this.borders.length * this.delay);
        int frame = (int)(animTime / this.delay);
        this.borders[frame].paintBorder(c, g, x, y, width, height);
    }
}

