/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import ch.randelshofer.quaqua.colorchooser.ColorSliderModel;
import java.awt.Color;
import java.awt.color.ColorSpace;
import javax.swing.DefaultBoundedRangeModel;

public class GrayColorSliderModel
extends ColorSliderModel {
    private ColorSpace colorSpace;
    float[] rgb = new float[3];
    float[] gray = new float[1];

    public GrayColorSliderModel() {
        super(new DefaultBoundedRangeModel[]{new DefaultBoundedRangeModel(0, 0, 0, 100)});
        this.colorSpace = ColorSpace.getInstance(1003);
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getRGB() {
        this.rgb = this.colorSpace.toRGB(new float[]{(float)this.components[0].getValue() / 100.0f});
        return 0xFF000000 | (int)(this.rgb[0] * 255.0f) << 16 | (int)(this.rgb[1] * 255.0f) << 8 | (int)(this.rgb[2] * 255.0f);
    }

    @Override
    public void setRGB(int newRGB) {
        this.rgb[0] = (float)((newRGB & 0xFF0000) >>> 16) / 255.0f;
        this.rgb[1] = (float)((newRGB & 0xFF00) >>> 8) / 255.0f;
        this.rgb[2] = (float)(newRGB & 0xFF) / 255.0f;
        this.gray = this.colorSpace.fromRGB(this.rgb);
        this.components[0].setValue((int)(this.gray[0] * 100.0f));
    }

    @Override
    public int toRGB(int[] values) {
        this.rgb = this.colorSpace.toRGB(new float[]{(float)values[0] / 100.0f});
        return 0xFF000000 | (int)(this.rgb[0] * 255.0f) << 16 | (int)(this.rgb[1] * 255.0f) << 8 | (int)(this.rgb[2] * 255.0f);
    }

    @Override
    public Color getColor() {
        this.gray[0] = (float)this.components[0].getValue() / 100.0f;
        return new Color(this.colorSpace, this.gray, 1.0f);
    }

    @Override
    public void setColor(Color color) {
        this.gray = color.getColorSpace().equals(this.colorSpace) ? color.getColorComponents(this.gray) : color.getColorComponents(this.colorSpace, this.gray);
        this.rgb = this.colorSpace.toRGB(this.gray);
        this.components[0].setValue((int)(this.gray[0] * 100.0f));
    }
}

