/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.datatransfer;

import ch.randelshofer.quaqua.datatransfer.MimeType;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DefaultTransferable
implements Transferable {
    private byte[] data;
    private DataFlavor flavor;

    public DefaultTransferable(String data, String mimetype, String description) {
        this(data.toCharArray(), mimetype, description);
    }

    public DefaultTransferable(char[] chars, String mimetype, String description) {
        try {
            MimeType mt = new MimeType(mimetype);
            String charset = mt.getParameter("charset");
            if (charset == null) {
                charset = "UTF-8";
                mt.setParameter("charset", charset);
            }
            this.data = new String(chars).getBytes(charset);
            this.flavor = new DataFlavor(mt.toString(), description);
        }
        catch (Exception e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public DefaultTransferable(byte[] data, String mimetype, String description) {
        this.data = data;
        this.flavor = new DataFlavor(mimetype, description);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.flavor)) {
            return new ByteArrayInputStream(this.data);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.flavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.flavor);
    }
}

