/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.QuaquaNativeBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JScrollBar;

public class QuaquaLionNativeScrollBarBorder
extends QuaquaNativeBorder {
    public QuaquaLionNativeScrollBarBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
        super(0, widget, imageInsets, borderInsets);
    }

    public QuaquaLionNativeScrollBarBorder(OSXAquaPainter.Widget widget) {
        super(0, widget);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        OSXAquaPainter.Size size;
        OSXAquaPainter.State state;
        JScrollBar sb = (JScrollBar)c;
        Insets vm = this.getVisualMargin(c);
        x += vm.left;
        y += vm.top;
        width -= vm.left + vm.right;
        height -= vm.top + vm.bottom;
        int args = 0;
        if (QuaquaUtilities.isOnActiveWindow(c)) {
            state = OSXAquaPainter.State.active;
            args |= 1;
        } else {
            state = OSXAquaPainter.State.inactive;
        }
        if (!c.isEnabled()) {
            state = OSXAquaPainter.State.disabled;
            args |= 4;
        }
        this.painter.setState(state);
        boolean isFocused = QuaquaUtilities.isFocused(c);
        args |= isFocused ? 32 : 0;
        this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocused ? 1.0 : 0.0);
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                size = OSXAquaPainter.Size.regular;
                break;
            }
            case SMALL: {
                size = OSXAquaPainter.Size.small;
                break;
            }
            case MINI: {
                size = OSXAquaPainter.Size.mini;
            }
        }
        this.painter.setSize(size);
        args |= size.getId() << 6;
        if (sb.getOrientation() == 0) {
            this.painter.setOrientation(OSXAquaPainter.Orientation.horizontal);
            args |= 0x80000;
        } else {
            this.painter.setOrientation(OSXAquaPainter.Orientation.vertical);
        }
        if (sb.getMaximum() != sb.getMinimum()) {
            double totalSize = sb.getMaximum() - sb.getMinimum();
            this.painter.setValueByKey(OSXAquaPainter.Key.thumbProportion, (double)sb.getVisibleAmount() / totalSize);
            this.painter.setValueByKey(OSXAquaPainter.Key.value, (double)(sb.getValue() - sb.getMinimum()) / totalSize);
        } else {
            this.painter.setValueByKey(OSXAquaPainter.Key.thumbProportion, 0.0);
        }
        this.paint(c, g, x, y, width, height, args);
    }
}

