/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.app.rotate;

import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.legend.picturemarkersymboltable.lib.api.PictureMarkerSymbolTableLegend;
import org.gvsig.legend.urbanhorizontalsignage.app.rotate.RotatePointBehavior;
import org.gvsig.legend.urbanhorizontalsignage.app.rotate.RotatePointListenerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatePointExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(RotatePointExtension.class);

    public void initialize() {
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareToIgnoreCase("layer-modify-rotatepoint") != 0) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return;
        }
        MapControl mapControl = view.getMapControl();
        if (mapControl == null) {
            return;
        }
        MapContext mapContext = mapControl.getMapContext();
        if (mapContext == null) {
            return;
        }
        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
        if (layer == null) {
            return;
        }
        if (!mapControl.hasTool("RotatePoint")) {
            RotatePointListenerImpl listener = new RotatePointListenerImpl();
            RotatePointBehavior behavior = new RotatePointBehavior(listener);
            mapControl.addBehavior("RotatePoint", (Behavior)behavior);
        }
        mapControl.setTool("RotatePoint");
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return false;
        }
        MapContext mapContext = viewdoc.getMapContext();
        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
        if (layer == null) {
            return false;
        }
        if (!layer.isAvailable()) {
            return false;
        }
        try {
            FeatureStore store = layer.getFeatureStore();
            FeatureSelection selection = store.getFeatureSelection();
            if (selection.isEmpty()) {
                return false;
            }
            return layer.getLegend() instanceof PictureMarkerSymbolTableLegend;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get selection from layer '" + layer.getName() + "'.", (Throwable)ex);
            return false;
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        return application.getActiveDocument(ViewManager.TYPENAME) != null;
    }
}

