/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.gvsig.newlayer.NewLayerManager;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.impl.DefaultNewLayerService;
import org.gvsig.newlayer.impl.DefaultNewLayerWizard;
import org.gvsig.newlayer.impl.preferences.DefaultNewLayerPreferencesComponent;
import org.gvsig.newlayer.preferences.NewLayerPreferencesComponent;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.gvsig.tools.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNewLayerManager
implements NewLayerManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNewLayerManager.class);
    private static final String EP_NEWLAYER_NAME = "NewLayer.manager.providers";
    private static final String EP_NEWLAYER_DESCRIPTION = "NewLayer providers";
    private Map<NewLayerProviderFactory, Boolean> providerStatus = new HashMap<NewLayerProviderFactory, Boolean>();

    public NewLayerService createNewLayerService() {
        return new DefaultNewLayerService(this);
    }

    public void registerProvider(NewLayerProviderFactory factory) {
        ExtensionPoint ep = this.getNewLayerProvidersExtensionPoint();
        ep.append(factory.getName(), factory.getDescription(), (ExtensionSingleton)factory);
    }

    public NewLayerWizard createNewLayerWizard(NewLayerService service) {
        URL iconURL = this.getClass().getClassLoader().getResource("org/gvsig/newlayer/lib/impl/images/panel/view-new-layer-illustration.png");
        ImageIcon logo = null;
        if (iconURL != null) {
            logo = new ImageIcon(iconURL);
        }
        return new DefaultNewLayerWizard(logo, service);
    }

    public NewLayerProviderFactory getNewLayerProviderFactory(String providerName) throws ServiceException {
        ExtensionPoint ep = this.getNewLayerProvidersExtensionPoint();
        try {
            return (NewLayerProviderFactory)ep.create(providerName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void enableProvider(NewLayerProviderFactory factory, Boolean value) {
        this.providerStatus.put(factory, (boolean)value);
    }

    public NewLayerPreferencesComponent createNewLayerProvidersPreferences() {
        return new DefaultNewLayerPreferencesComponent();
    }

    public List<NewLayerProviderFactory> getProviders() {
        ExtensionPoint ep = this.getNewLayerProvidersExtensionPoint();
        ArrayList<NewLayerProviderFactory> providers = new ArrayList<NewLayerProviderFactory>();
        for (ExtensionPoint.Extension extension : ep) {
            NewLayerProviderFactory factory;
            try {
                factory = (NewLayerProviderFactory)extension.create();
            }
            catch (InstantiationException e) {
                LOG.warn("Can't create NewLayerProviderFactory " + extension.getName(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOG.warn("Can't create NewLayerProviderFactory " + extension.getName(), (Throwable)e);
                continue;
            }
            providers.add(factory);
        }
        return providers;
    }

    private ExtensionPoint getNewLayerProvidersExtensionPoint() {
        ExtensionPointManager epmgr = ToolsLocator.getExtensionPointManager();
        return epmgr.add(EP_NEWLAYER_NAME, EP_NEWLAYER_DESCRIPTION);
    }

    public List<NewLayerProviderFactory> getProviders(NewLayerManager.STORETYPE filter) {
        return this.getProviders();
    }

    public boolean isProviderEnabled(NewLayerProviderFactory factory) {
        Boolean status = this.providerStatus.get(factory);
        return status == null ? true : status;
    }
}

