/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jwizardcomponent.CancelAction;
import jwizardcomponent.DefaultJWizardComponents;
import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.newlayer.NewLayerException;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerServiceException;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.impl.AddNewLayerQuestionPanel;
import org.gvsig.newlayer.impl.TypeSelectorPanel;
import org.gvsig.newlayer.impl.panels.FeatureTypePanel;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNewLayerWizard
extends NewLayerWizard {
    private static final long serialVersionUID = -5827106636136663823L;
    private final NewLayerService service;
    private AddNewLayerQuestionPanel addNewLayerQuestionPanel;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNewLayerWizard.class);
    private String addTableToProjectTitle;
    private String addTableToProjectLabel;

    public DefaultNewLayerWizard(ImageIcon logo, NewLayerService service) {
        super(logo);
        this.service = service;
        this.getWizardComponents().setFinishAction((FinishAction)new MyFinishAction((JWizardComponents)this.getWizardComponents()));
        this.getWizardComponents().setCancelAction((CancelAction)new MyCancelAction(this.getWizardComponents()));
        this.createTypeSelector();
        this.setFinishButtonEnabled(false);
        this.setBackButtonEnabled(false);
        this.setNextButtonEnabled(false);
        Dimension screensize = ToolsSwingUtils.getDesktopPanelSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)((Object)this), (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)35)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)140)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
    }

    public NewLayerService getService() {
        return this.service;
    }

    private void createTypeSelector() {
        TypeSelectorPanel panel = new TypeSelectorPanel(this);
        this.addOptionPanel(panel);
    }

    public NewLayerProviderPanel createFeatureTypePanel() {
        FeatureTypePanel panel = new FeatureTypePanel(this, this.service.getProvider());
        return panel;
    }

    private void createProviderPanels() {
        DefaultJWizardComponents wizardComponents = this.getWizardComponents();
        for (int i = wizardComponents.getWizardPanelList().size() - 1; i >= 1; --i) {
            wizardComponents.removeWizardPanel(i);
        }
        List panels = this.service.getProvider().createPanels((NewLayerWizard)this);
        for (NewLayerProviderPanel panel : panels) {
            this.addOptionPanel(new OptionPanelWrapper(panel));
        }
        this.createAddNewLayerQuestionPanel();
    }

    private AddNewLayerQuestionPanel getAddNewLayerQuestionPanel() {
        if (this.addNewLayerQuestionPanel == null) {
            this.addNewLayerQuestionPanel = new AddNewLayerQuestionPanel(this, this.addTableToProjectTitle, this.addTableToProjectLabel);
        }
        return this.addNewLayerQuestionPanel;
    }

    private void createAddNewLayerQuestionPanel() {
        this.addOptionPanel(this.getAddNewLayerQuestionPanel());
    }

    private boolean getAddLayerToView() {
        return this.getAddNewLayerQuestionPanel().getAddTableToProject();
    }

    public void setType(NewLayerProviderFactory currentType) {
        this.service.setProviderFactory(currentType);
        this.createProviderPanels();
    }

    private JButton getButton(int button) {
        switch (button) {
            case 0: {
                return this.getWizardComponents().getBackButton();
            }
            case 1: {
                return this.getWizardComponents().getNextButton();
            }
            case 2: {
                return this.getWizardComponents().getFinishButton();
            }
            case 3: {
                return this.getWizardComponents().getCancelButton();
            }
        }
        throw new IllegalArgumentException("Illegal button value (" + button + ").");
    }

    public void setButtonEnabled(int button, boolean enabled) {
        this.getButton(button).setEnabled(enabled);
    }

    public void setButtonText(int button, String text) {
        this.getButton(button).setText(text);
    }

    public boolean isButtonEnabled(int button) {
        return this.getButton(button).isEnabled();
    }

    public String getButtonText(int button) {
        return this.getButton(button).getText();
    }

    public void setAddTableToProjectTitle(String text) {
        this.addTableToProjectTitle = text;
    }

    public void setAddTableToProjectLabel(String text) {
        this.addTableToProjectLabel = text;
    }

    private class MyCancelAction
    extends CancelAction {
        public MyCancelAction(DefaultJWizardComponents wizardComponents) {
            super((JWizardComponents)wizardComponents);
        }

        public void performAction() {
            DefaultNewLayerWizard.this.setVisible(false);
        }
    }

    private class MyFinishAction
    extends FinishAction {
        public MyFinishAction(JWizardComponents arg0) {
            super(arg0);
        }

        public void performAction() {
            if (DefaultNewLayerWizard.this.getService().getStoreProviderName() == null) {
                JOptionPane.showMessageDialog(null, Messages.getText((String)"new_layer_not_store_name"), Messages.getText((String)"new_layer"), 2);
                return;
            }
            if (DefaultNewLayerWizard.this.getService().getNewStoreParametersQuietly() == null) {
                JOptionPane.showMessageDialog(null, Messages.getText((String)"new_layer_parameters_missing"), Messages.getText((String)"new_layer"), 2);
                return;
            }
            try {
                DefaultNewLayerWizard.this.getService().createTable();
            }
            catch (NewLayerServiceException e) {
                LOG.info("Cannot create the new layer", (Throwable)e);
                JOptionPane.showMessageDialog(null, Messages.getText((String)"cant_create_new_layer") + "\n" + e.getMessageStack(), Messages.getText((String)"new_layer"), 0);
                return;
            }
            DefaultNewLayerWizard.this.setVisible(false);
        }
    }

    private class OptionPanelWrapper
    implements OptionPanel {
        private final NewLayerProviderPanel panel;

        public OptionPanelWrapper(NewLayerProviderPanel panel) {
            this.panel = panel;
        }

        public String getPanelTitle() {
            return this.panel.getTitlePanel();
        }

        public void nextPanel() throws NotContinueWizardException {
            try {
                if (!this.panel.validatePanel()) {
                    throw new NotContinueWizardException("Error validating the form", (Component)this.panel.asJComponent(), false);
                }
            }
            catch (NewLayerException e) {
                LOG.info("Error validating the form", (Throwable)e);
                throw new NotContinueWizardException("Error validating the form", (Throwable)e, (Component)this.panel.asJComponent());
            }
        }

        public void lastPanel() {
        }

        public void updatePanel() {
            this.panel.enterPanel();
        }

        public JPanel getJPanel() {
            return (JPanel)this.panel.asJComponent();
        }
    }
}

