/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl.panels;

import javax.swing.JComponent;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.newlayer.NewLayerProvider;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.spi.NewLayerPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class FeatureTypePanel
implements NewLayerProviderPanel {
    private final NewLayerProvider provider;
    private final NewLayerWizard wizard;
    private org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel featureTypeEditor;

    public FeatureTypePanel(NewLayerWizard wizard, NewLayerProvider provider) {
        this.provider = provider;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        DataManager dataManager = DALLocator.getDataManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        this.featureTypeEditor = dataSwingManager.createFeatureTypePanel();
        this.featureTypeEditor.setDefaultProjection(this.wizard.getService().getDefaultProjection());
        this.featureTypeEditor.setMode(1);
        this.featureTypeEditor.put((FeatureType)ft);
    }

    public void previousPanel() {
        EditableFeatureType ft = this.provider.getFeatureType();
        this.featureTypeEditor.fetch(ft);
    }

    public void enterPanel() {
        this.featureTypeEditor.setDefaultProjection(this.wizard.getService().getDefaultProjection());
        EditableFeatureType ft = this.provider.getFeatureType();
        if (ft != null) {
            this.featureTypeEditor.put((FeatureType)ft);
        }
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Columns_definition");
    }

    public void nextPanel() {
        EditableFeatureType ft = this.provider.getFeatureType();
        this.featureTypeEditor.fetch(ft);
    }

    public boolean validatePanel() throws NewLayerPanelValidationException {
        try {
            if (this.featureTypeEditor.isEditing()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                dialogs.messageDialog(i18n.getTranslation("_Accept_o_discard_the_attribute_changes_to_continue"), i18n.getTranslation("_Columns_definition"), 1);
                return false;
            }
            EditableFeatureType ft = this.provider.getFeatureType();
            this.featureTypeEditor.fetch(ft);
            return ft.size() != 0;
        }
        catch (Exception ex) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            dialogs.messageDialog(i18n.getTranslation("_Data_of_panel_are_invalid") + "\n" + BaseException.getMessageStack((Throwable)ex, (int)2), i18n.getTranslation("_Columns_definition"), 2);
            return false;
        }
    }

    public JComponent asJComponent() {
        return this.featureTypeEditor.asJComponent();
    }
}

