/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HttpParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"x-httpresponse");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        block16: {
            org.netpreserve.jwarc.HttpParser parser = new org.netpreserve.jwarc.HttpParser();
            parser.lenientRequest();
            parser.lenientResponse();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            try (ReadableByteChannel channel = Channels.newChannel((InputStream)new CloseShieldInputStream(stream));){
                int len = channel.read(buffer);
                buffer.flip();
                if (len < 0) {
                    throw new EOFException();
                }
                parser.parse(channel, buffer);
                MessageHeaders messageHeaders = parser.headers();
                this.updateMetadata(messageHeaders, metadata);
                long contentLength = messageHeaders.sole("Content-Length").map(Long::parseLong).orElse(0L);
                if (contentLength <= 0L) break block16;
                LengthedBody messageBody = LengthedBody.create((ReadableByteChannel)channel, (ByteBuffer)buffer, (long)contentLength);
                Metadata payloadMetadata = new Metadata();
                try (InputStream messageStream = messageBody.stream();){
                    this.parsePayload(messageStream, (ContentHandler)xhtml, payloadMetadata, context);
                }
            }
            finally {
                xhtml.endDocument();
            }
        }
    }

    private void parsePayload(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException {
        EmbeddedDocumentExtractor ex = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        if (ex.shouldParseEmbedded(metadata)) {
            ex.parseEmbedded(stream, handler, metadata, true);
        }
    }

    private void updateMetadata(MessageHeaders messageHeaders, Metadata metadata) {
    }
}

