/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.HashMap;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDExternalGraphic;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalGraphicElement {
    public static void append(SLDExternalGraphic obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("ExternalGraphic");
        String v = version == null ? "1.0.0" : version;
        HashMap<String, String> atts = new HashMap<String, String>();
        if (v.compareToIgnoreCase("1.1.0") == 0) {
            if (obj.isOnlineResource()) {
                atts.put("xlink:href", obj.getOnlineResource());
                xb.writeTag("OnlineResource", atts);
            } else {
                xb.openTag("InlineContent");
                if (obj.getInlineContent() != null) {
                    xb.writeRaw(new String(obj.getInlineContent()));
                }
                xb.closeTag();
            }
        } else {
            atts.put("xlink:href", obj.getOnlineResource());
            xb.writeTag("OnlineResource", atts);
        }
        xb.writeTag("Format", obj.getFormat());
        xb.closeTag();
    }

    public static SLDExternalGraphic parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "ExternalGraphic");
        int tag = 0;
        SLDExternalGraphic resp = new SLDExternalGraphic();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "ExternalGraphic") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Format")) {
                        txt = parser.nextText();
                        resp.setFormat(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "OnlineResource")) {
                        String res = parser.getAttributeValue(null, "xlink:href");
                        if (res == null) {
                            throw new SLDReadException("URL not found (xlink:href att is missing) in online resource entity");
                        }
                        resp.setIsOnline(true);
                        resp.setOnlineResource(res);
                        parser.nextTag();
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "InlineContent")) {
                        txt = parser.nextText();
                        resp.setIsOnline(false);
                        resp.setInlineContent(txt.getBytes());
                        parser.nextTag();
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in external graphic: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

