/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicFill;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GraphicFillElement {
    public static void append(SLDGraphicFill obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("GraphicFill");
        if (obj.getGraphic() == null) {
            throw new InvalidSLDObjectException("GraphicFill", "No graphic found.");
        }
        GraphicElement.append(obj.getGraphic(), xb, version);
        xb.closeTag();
    }

    public static SLDGraphicFill parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "GraphicFill");
        int tag = 0;
        SLDGraphicFill resp = new SLDGraphicFill();
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, "GraphicFill") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Graphic")) {
                        SLDGraphic gra = GraphicElement.parse(parser, version);
                        resp.setGraphic(gra);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in graphic fill: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

