/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.FillElement;
import org.gvsig.sldsupport.impl.sld.parsing.StrokeElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDMark;
import org.gvsig.sldsupport.sld.symbol.misc.SLDFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MarkElement {
    public static List<String> WELL_KNOWN_NAMES = null;

    public static void append(SLDMark obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("Mark");
        if (version != null && version.compareToIgnoreCase("1.1.0") == 0) {
            MarkElement.appendMarkTypev110(obj, xb);
        } else {
            MarkElement.appendMarkTypev100(obj, xb);
        }
        if (obj.getFill() != null) {
            FillElement.append(obj.getFill(), xb, version);
        }
        if (obj.getStroke() != null) {
            StrokeElement.append(obj.getStroke(), xb, version);
        }
        xb.closeTag();
    }

    private static void appendMarkTypev100(SLDMark obj, XmlBuilder xb) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj.getMarkType() == 1) {
            if (obj.getWellKnownName() == null) {
                throw new InvalidSLDObjectException("Mark", "No well-known name found");
            }
            MarkElement.checkWellKnownName(obj.getWellKnownName());
            xb.writeTag("WellKnownName", obj.getWellKnownName());
        }
    }

    private static void checkWellKnownName(String name) throws UnsupportedSLDObjectException {
        if (!WELL_KNOWN_NAMES.contains(name.toLowerCase())) {
            throw new UnsupportedSLDObjectException("Mark", "Unsupported well-known name for mark: " + name);
        }
    }

    private static void appendMarkTypev110(SLDMark obj, XmlBuilder xb) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        boolean online_inlne = false;
        switch (obj.getMarkType()) {
            case 1: {
                if (obj.getWellKnownName() == null) {
                    throw new InvalidSLDObjectException("Mark", "No well-known name found");
                }
                MarkElement.checkWellKnownName(obj.getWellKnownName());
                xb.writeTag("WellKnownName", obj.getWellKnownName());
                break;
            }
            case 3: {
                online_inlne = true;
                if (obj.getInlineContent() == null) {
                    throw new InvalidSLDObjectException("Mark", "No inline content found");
                }
                xb.openTag("InlineContent");
                xb.writeRaw(new String(obj.getInlineContent()));
                xb.closeTag();
                break;
            }
            case 2: {
                online_inlne = true;
                if (obj.getOnlineResource() == null) {
                    throw new InvalidSLDObjectException("Mark", "No online resource URL found");
                }
                HashMap<String, String> atts = new HashMap<String, String>();
                atts.put("xlink:href", obj.getOnlineResource());
                xb.writeTag("OnlineResource", atts);
                break;
            }
        }
        if (online_inlne) {
            if (obj.getFormat() == null) {
                throw new InvalidSLDObjectException("Mark", "Format entity is mandatory in this case");
            }
            xb.writeTag("Format", obj.getFormat());
            if (obj.getMarkIndex() != -1) {
                xb.writeTag("MarkIndex", Integer.toString(obj.getMarkIndex()));
            }
        }
    }

    public static SLDMark parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Mark");
        int tag = 0;
        SLDMark resp = new SLDMark();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "Mark") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "WellKnownName")) {
                        txt = parser.nextText();
                        resp.setMarkType(1);
                        resp.setWellKnownName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "OnlineResource")) {
                        txt = parser.getAttributeValue(null, "xlink:href");
                        if (txt == null) {
                            throw new SLDReadException("URL not found (xlink:href att is missing) in online resource entity");
                        }
                        resp.setOnlineResource(txt);
                        resp.setMarkType(2);
                        resp.setOnlineResource(txt);
                        parser.nextTag();
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "InlineContent")) {
                        txt = parser.nextText();
                        resp.setMarkType(3);
                        resp.setInlineContent(txt.getBytes());
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Format")) {
                        txt = parser.nextText();
                        resp.setFormat(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "MarkIndex")) {
                        txt = parser.nextText();
                        int ind = SLDUtils.parseInteger(txt);
                        resp.setMarkIndex(ind);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Fill")) {
                        SLDFill fil = FillElement.parse(parser, version);
                        resp.setFill(fil);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Stroke")) {
                        SLDStroke stro = StrokeElement.parse(parser, version);
                        resp.setStroke(stro);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in Mark: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }

    static {
        WELL_KNOWN_NAMES = new ArrayList<String>();
        WELL_KNOWN_NAMES.add("square");
        WELL_KNOWN_NAMES.add("circle");
        WELL_KNOWN_NAMES.add("triangle");
        WELL_KNOWN_NAMES.add("star");
        WELL_KNOWN_NAMES.add("cross");
        WELL_KNOWN_NAMES.add("x");
    }
}

